% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ggseqlogo}
\alias{ggseqlogo}
\title{Generate a ggplot object of sequence logos from the DNA frequency matrices.}
\usage{
ggseqlogo(M, is.scale = FALSE, A_col = "#00BA38", C_col = "#619CFF",
  G_col = "#B79F00", T_col = "#F8766D")
}
\arguments{
\item{M}{The DNA frequency matrices (4 * sequence lengths matrices).}

\item{is.scale}{whether heights are scaled according to information contents or not.}

\item{A_col}{The color for the "A" character.}

\item{C_col}{The color for the "C" character.}

\item{G_col}{The color for the "G" character.}

\item{T_col}{The color for the "T" character.}
}
\value{
a ggplot object of sequence logos
}
\description{
Generate a ggplot object of sequence logos from the DNA frequency matrices.
}
\examples{
ggseqlogo(matrix(rgamma(20, 1, 10), 4, 5), is.scale = TRUE)
}

