# do the delta-delta-Ct calculation, assuming that the amplification efficiency of 
# everything is 2.0 (exact doubling).

# hard-coding number of technical replicates
techreps = 3

#works = FALSE

# NOW FIXED (i think):
# need to fix such that new ddCt function is used properly!!!!
# do this before using, and also apply in previous qPCR analyses!!!!
#stopifnot(works)

# added error calculation according to abi: 
# http://www3.appliedbiosystems.com/cms/groups/mcb_support/documents/generaldocuments/cms_042380.pdf
ddCt = function(both,...) {
	print(both)
  # throw out failed rxns
	test = as.numeric(na.omit(both[,1]))
	ref = as.numeric(na.omit(both[,2]))
	#print(rbind(test,ref))
	
	meanT = mean(test)
	sdT = sd(test) / sqrt(length(test))
	meanR = mean(ref)
	sdR = sd(ref) / sqrt(length(test))
	
	dCt = meanR - meanT
	sdCt = sqrt(sdT+sdR)
	
	ddCt_mean = 2^(dCt)
	# sd bounds
	ddCt_upper = 2^(dCt+sdCt)
	ddCt_lower = 2^(dCt-sdCt)
	
	out = c(ddCt_mean,ddCt_upper,ddCt_lower)
	names(out) = c('mean','upper','lower')
	return(out)
	
	}

# data!!!
thing = read.table('~/Dropbox/Ath_STRs/qpcr_expts/mop_090816_str95706_47883.txt',comment.char='#',header=T,sep='\t',stringsAsFactors=FALSE)

## sample ids = 'genos'
#1	Col
#2	elf3-200
#3	Ws
#4	elf3-4


# just hard-coding all of the metadata in
genos = rep(NA,96)
genos[thing$Rownum %in% c('A') & thing$Colnum %in% c(1,2,3)] = 1
genos[thing$Rownum %in% c('B') & thing$Colnum %in% c(1,2,3)] = 2
genos[thing$Rownum %in% c('C') & thing$Colnum %in% c(1,2,3)] = 3
genos[thing$Rownum %in% c('D') & thing$Colnum %in% c(1,2,3)] = 4
genos[thing$Rownum %in% c('E') & thing$Colnum %in% c(1,2,3)] = 5
genos[thing$Rownum %in% c('F') & thing$Colnum %in% c(1,2,3)] = 1
genos[thing$Rownum %in% c('G') & thing$Colnum %in% c(1,2,3)] = 3
genos[thing$Rownum %in% c('H') & thing$Colnum %in% c(1,2,3)] = 5 
genos[thing$Rownum %in% c('A') & thing$Colnum %in% c(4,5,6)] = 2
genos[thing$Rownum %in% c('B') & thing$Colnum %in% c(4,5,6)] = 4
genos[thing$Rownum %in% c('C') & thing$Colnum %in% c(4,5,6)] = 5

# useful for plotting
genotype = c('Col', 'Mr-0','Ra-0')

gene = rep(NA,96)
gene[thing$Colnum %in% c(1,2,3) & thing$Rownum %in% c('A','B','C','D','E')] = 'UBC'
gene[thing$Colnum %in% c(1,2,3) & thing$Rownum %in% c('F','G','H')] = 'str47883_expr'
gene[thing$Colnum %in% c(4,5,6) & thing$Rownum %in% c('A','B','C')] = 'str95706_expr'

all = na.omit(cbind(thing[,c('Rownum','Colnum','Cp')],gene,genos))


express = list()
for (gen in na.omit(unique(all$gene))) {
	print(gen)
  if (is.na(gen)) {
		next
		}
	genos_in = all[all$gene == gen,'genos']
	expr = all[all$gene == gen,]
	control = all[all$gene == 'UBC',]
	#print(cbind(expr$Cp,thing$Cp[gene=='UBC']))
	
	# had a bug- not all genes sampled for all strains!! this is to limit 
	limit_genos = intersect(expr$genos,control$genos)
	expr = expr[expr$genos %in% limit_genos,]
	control = control[control$genos %in% limit_genos,]
	
	cp_dat = cbind(expr$Cp,ref=control$Cp)
	express[[gen]] = matrix(unlist(by(cp_dat, genos_in, ddCt,simplify=TRUE)),3)
	rownames(express[[gen]]) = c('mean','upper','lower')
	}

expression = list()
for ( gen in c('str47883_expr','str95706_expr')) {
	geneout = list()
	geneout[['mean']] = c()
	geneout[['upper']] = c()
	geneout[['lower']] = c()
	for ( geno in 1:ncol(express[[gen]])) {
		# reference sample - not applied yet
		geneout[['mean']][geno] = unlist(express[[gen]]['mean',geno] / express[[gen]]['mean',1])
		geneout[['upper']][geno] = unlist(express[[gen]]['upper',geno] / express[[gen]]['mean',1])
		geneout[['lower']][geno] = unlist(express[[gen]]['lower',geno] / express[[gen]]['mean',1])
		}
	expression[[gen]] = geneout
	}

#rep1 = expression[['LSH9']][['mean']][1:4]
#rep2 = expression[['LSH9']][['mean']][5:8]

# run the old script to get 3rd rep
#source('code/qpcr_analysis_lsh9expr_121515.R')
#rep3 = expression[['LSH9']][['mean']]#[c(3,4,1,2)]

# 4th???
#source('code/qpcr_analysis_lsh9expr.R')
#rep4 = expression[['LSH9']][['mean']][c(3,4,1,2)]

# do this in a somewhat hacky way
#expression=list()
#expression[['mean']] = c()
#expression[['upper']] = c()
#expression[['lower']] = c()

#for (geno in 1:length(expression[[1]][['mean']])) {
 # expression[['mean']][geno] = mean( c(rep1[geno], rep2[geno], rep3[geno], rep4[geno]) )
  #expression[['upper']][geno] = sd( c(rep1[geno], rep2[geno], rep3[geno], rep4[geno]) )/sqrt(4) + expression[['mean']][geno]
#  expression[['lower']][geno] = -sd( c(rep1[geno], rep2[geno], rep3[geno], rep4[geno]) )/sqrt(4) + expression[['mean']][geno]
#  }

# renormalize
#expression$str95706_expr[['upper']] = expression$str95706_expr[['upper']] / expression$str95706_expr[['mean']][2]
#expression$str95706_expr[['lower']] = expression$str95706_expr[['lower']] / expression$str95706_expr[['mean']][2]
#expression$str95706_expr[['mean']] = expression$str95706_expr[['mean']] / expression$str95706_expr[['mean']][2]

#expression$str95706_expr[['upper']] = expression$str47883_expr[['upper']] / expression$str47883_expr[['mean']][2]
#expression$str47883_expr[['lower']] = expression$str47883_expr[['lower']] / expression$str47883_expr[['mean']][2]
#expression$str47883_expr[['mean']] = expression$str47883_expr[['mean']] / expression$str47883_expr[['mean']][2]


#genotype = c('Ws', 'elf3-4','Col', 'elf3-200')
genotype1 = c('Col','Nd-1','Omo2-1')
genotype2 = c('Kz-9','Omo2-1','Wei-0')

#pdf('lsh9_qpcr_090216.pdf',width=4,height=6)
par( mfrow = c(1,2) )
lshplot = barplot(unlist(expression$str95706_expr[['mean']]), main='Calmodulin expression',
 col=gray(c(1,.75,.4)), names=genotype2, las=2, beside=TRUE	, ylim=c(0,2), ylab = 'Relative expression')
arrows(lshplot[,],unlist(expression$str95706_expr[['lower']]),lshplot[,],unlist(expression$str95706_expr[['upper']]),length=0.1,angle=90,code=3)
lshplot = barplot(unlist(expression$str47883_expr[['mean']]), main='MEE36 expression',
                  col=gray(c(1,.75,.4)), names=genotype1, las=2, beside=TRUE,	ylim=c(0,12), ylab = 'Relative expression')
arrows(lshplot[,],unlist(expression$str47883_expr[['lower']]),lshplot[,],unlist(expression$str47883_expr[['upper']]),length=0.1,angle=90,code=3)

#coplot = barplot(unlist(expression[['CO']]['mean']), main='CO expression', log='y',
# col=c('white','red'), las=2, beside=TRUE, ylim = c(.01,20))
#arrows(coplot,unlist(expression[['CO']]['lower']),coplot,unlist(expression[['CO']]['upper']),length=0)
#ftplot = barplot(unlist(expression[['FT']]['mean']), main='FT expression',  log='y',
#col=c('white','red'), las=2, beside=TRUE, ylim = c(.01,20) )
#arrows(ftplot,unlist(expression[['FT']]['lower']),ftplot,unlist(expression[['FT']]['upper']),length=0)

#dev.off()
