# do the delta-delta-Ct calculation, assuming that the amplification efficiency of 
# everything is 2.0 (exact doubling).

# hard-coding number of technical replicates
techreps = 3

#works = FALSE

# NOW FIXED (i think):
# need to fix such that new ddCt function is used properly!!!!
# do this before using, and also apply in previous qPCR analyses!!!!
#stopifnot(works)

# added error calculation according to abi: 
# http://www3.appliedbiosystems.com/cms/groups/mcb_support/documents/generaldocuments/cms_042380.pdf
ddCt = function(both,...) {
	print(both)
  # throw out failed rxns
	test = as.numeric(na.omit(both[,1]))
	ref = as.numeric(na.omit(both[,2]))
	#print(rbind(test,ref))
	
	meanT = mean(test)
	sdT = sd(test) / sqrt(length(test))
	meanR = mean(ref)
	sdR = sd(ref) / sqrt(length(test))
	
	dCt = meanR - meanT
	sdCt = sqrt(sdT+sdR)
	
	ddCt_mean = 2^(dCt)
	# sd bounds
	ddCt_upper = 2^(dCt+sdCt)
	ddCt_lower = 2^(dCt-sdCt)
	
	out = c(ddCt_mean,ddCt_upper,ddCt_lower)
	names(out) = c('mean','upper','lower')
	return(out)
	
	}

# data!!!
thing = read.table('~/Dropbox/Ath_STRs/qpcr_expts/mop_090816_str65400_expr_colmrra.txt',comment.char='#',header=T,sep='\t',stringsAsFactors=FALSE)

## sample ids = 'genos'
#1	Col
#2	elf3-200
#3	Ws
#4	elf3-4


# just hard-coding all of the metadata in
genos = rep(NA,96)
genos[thing$Rownum %in% c('A') & thing$Colnum %in% c(7,8,9,10,11,12)] = 2
genos[thing$Rownum %in% c('B') & thing$Colnum %in% c(7,8,9,10,11,12)] = 3
genos[thing$Rownum %in% c('C') & thing$Colnum %in% c(7,8,9,10,11,12)] = 1
genos[thing$Rownum %in% c('D') & thing$Colnum %in% c(7,8,9)] = 2
genos[thing$Rownum %in% c('E') & thing$Colnum %in% c(7,8,9)] = 3
genos[thing$Rownum %in% c('F') & thing$Colnum %in% c(7,8,9)] = 1
#genos[thing$Rownum %in% c('G')] = 8
#genos[thing$Rownum %in% c('H')] = 7 

# useful for plotting
genotype = c('Col', 'Mr-0','Ra-0')

gene = rep(NA,96)
gene[thing$Colnum %in% c(7,8,9) & thing$Rownum %in% c('A','B','C')] = 'NTM1_STRintron'
gene[thing$Colnum %in% c(10,11,12) & thing$Rownum %in% c('A','B','C')] = 'NTM1_RT'
gene[thing$Colnum %in% c(7,8,9) & thing$Rownum %in% c('D','E','F')] = 'UBC'

all = na.omit(cbind(thing[,4:7],gene,genos))


express = list()
for (gen in na.omit(unique(all$gene))) {
	print(gen)
  if (is.na(gen)) {
		next
		}
	genos_in = all[all$gene == gen,'genos']
	expr = all[all$gene == gen,]
	control = all[all$gene == 'UBC',]
	#print(cbind(expr$Cp,thing$Cp[gene=='UBC']))
	cp_dat = cbind(expr$Cp,ref=control$Cp)
	express[[gen]] = matrix(unlist(by(cp_dat, genos_in, ddCt,simplify=TRUE)),3)
	rownames(express[[gen]]) = c('mean','upper','lower')
	}

expression = list()
for ( gen in c('NTM1_STRintron','NTM1_RT')) {
	geneout = list()
	geneout[['mean']] = c()
	geneout[['upper']] = c()
	geneout[['lower']] = c()
	for ( geno in 1:max(na.omit(genos))) {
		# reference sample - not applied yet
		geneout[['mean']][geno] = unlist(express[[gen]]['mean',geno] / express[[gen]]['mean',1])
		geneout[['upper']][geno] = unlist(express[[gen]]['upper',geno] / express[[gen]]['mean',1])
		geneout[['lower']][geno] = unlist(express[[gen]]['lower',geno] / express[[gen]]['mean',1])
		}
	expression[[gen]] = geneout
	}

#rep1 = expression[['LSH9']][['mean']][1:4]
#rep2 = expression[['LSH9']][['mean']][5:8]

# run the old script to get 3rd rep
#source('code/qpcr_analysis_lsh9expr_121515.R')
#rep3 = expression[['LSH9']][['mean']]#[c(3,4,1,2)]

# 4th???
#source('code/qpcr_analysis_lsh9expr.R')
#rep4 = expression[['LSH9']][['mean']][c(3,4,1,2)]

# do this in a somewhat hacky way
#expression=list()
#expression[['mean']] = c()
#expression[['upper']] = c()
#expression[['lower']] = c()

#for (geno in 1:length(expression[[1]][['mean']])) {
 # expression[['mean']][geno] = mean( c(rep1[geno], rep2[geno], rep3[geno], rep4[geno]) )
  #expression[['upper']][geno] = sd( c(rep1[geno], rep2[geno], rep3[geno], rep4[geno]) )/sqrt(4) + expression[['mean']][geno]
#  expression[['lower']][geno] = -sd( c(rep1[geno], rep2[geno], rep3[geno], rep4[geno]) )/sqrt(4) + expression[['mean']][geno]
#  }

# renormalize
expression$NTM1_STRintron[['upper']] = expression$NTM1_STRintron[['upper']] / expression$NTM1_STRintron[['mean']][2]
expression$NTM1_STRintron[['lower']] = expression$NTM1_STRintron[['lower']] / expression$NTM1_STRintron[['mean']][2]
expression$NTM1_STRintron[['mean']] = expression$NTM1_STRintron[['mean']] / expression$NTM1_STRintron[['mean']][2]

expression$NTM1_RT[['upper']] = expression$NTM1_RT[['upper']] / expression$NTM1_RT[['mean']][2]
expression$NTM1_RT[['lower']] = expression$NTM1_RT[['lower']] / expression$NTM1_RT[['mean']][2]
expression$NTM1_RT[['mean']] = expression$NTM1_RT[['mean']] / expression$NTM1_RT[['mean']][2]


#genotype = c('Ws', 'elf3-4','Col', 'elf3-200')
genotype = c('Ra-0','Col-0','Mr-0')

#pdf('lsh9_qpcr_090216.pdf',width=4,height=6)
par( mfrow = c(1,2) )
lshplot = barplot(unlist(expression$NTM1_STRintron[['mean']]), main='NTM1 expression (STR intron)',
 col=gray(c(1,.75,.4)), names=genotype, las=2, beside=TRUE	, ylim = c(.2,6), ylab = 'Relative expression')
arrows(lshplot[,],unlist(expression$NTM1_STRintron[['lower']]),lshplot[,],unlist(expression$NTM1_STRintron[['upper']]),length=0.1,angle=90,code=3)
lshplot = barplot(unlist(expression$NTM1_RT[['mean']]), main='NTM1 expression (other junction)',
                  col=gray(c(1,.75,.4)), names=genotype, las=2, beside=TRUE	, ylim = c(.4,6), ylab = 'Relative expression')
arrows(lshplot[,],unlist(expression$NTM1_RT[['lower']]),lshplot[,],unlist(expression$NTM1_RT[['upper']]),length=0.1,angle=90,code=3)

#coplot = barplot(unlist(expression[['CO']]['mean']), main='CO expression', log='y',
# col=c('white','red'), las=2, beside=TRUE, ylim = c(.01,20))
#arrows(coplot,unlist(expression[['CO']]['lower']),coplot,unlist(expression[['CO']]['upper']),length=0)
#ftplot = barplot(unlist(expression[['FT']]['mean']), main='FT expression',  log='y',
#col=c('white','red'), las=2, beside=TRUE, ylim = c(.01,20) )
#arrows(ftplot,unlist(expression[['FT']]['lower']),ftplot,unlist(expression[['FT']]['upper']),length=0)

#dev.off()
