# germ expt analysis
library(lme4)

it = read.csv('strwa/germ_expt_041317.csv',header=T,stringsAsFactors = FALSE)
surved=Surv(time=as.numeric(it$germ_time), event = it$germ)

surv_fit = survfit(Surv(it$germ_time, it$germ) ~ factor(it$genotype, levels=c('Col','S022640C','S028815c','S082363C','S095303c')))
plot(surv_fit, col=rainbow(5))
coxblock = coxph(formula = Surv(it$germ_time, it$germ) ~ it$genotype+it$sucrose)
print(summary(coxblock)) # might be over-interpreting

# less over-interpreting, i think? but acting very weird- probably just noisy due to low n. ah well.
log_fit = glm(it$germ ~ it$genotype, family='binomial')
print(summary(log_fit)) 
