# plot effect sizes of different variants.
effects = read.table('strwa/effect_sizes_ld_032417.txt',header=T)

str_loci = as.character(unique(effects$locus[!(grepl('snp',x=effects$locus))]))
snp_loci = as.character(effects$locus[grepl('snp',x=effects$locus)])
colors = rainbow(length(str_loci))
for (snp in snp_loci) {
 colors = append(colors,'white') 
}

names(colors) = append(str_loci,snp_loci)

# abs is probably fine
effects$estimate = abs(effects$estimate)

out = barplot(effects$estimate, col=colors[effects$locus], 
  horiz = T, xlab='Effect size (log days to flowering)', xlim= c(0,2.5), 
  names=effects$locus, las=2, cex.names=.45)

arrows(effects$estimate-effects$SE,out,effects$estimate+effects$SE, out , length=0)


# now 