# make haplo net for str 1665 and EDR1 upstream
require(pegas)
require(ape)
#dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/consens_align_noaly.clustal', format='clustal')
dna = read.dna('~/Dropbox/AthMIP_deadends/cmt2_gene_seq_in96.clustal', format='clustal')
#dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/consens_align.clustal', format='clustal')
#dna = read.dna('~/Dropbox/bioinformatics/1665_haplos_more.clustal',format='clustal')
e=dist.dna(dna) # not used?
njtree = nj(e)

cols = c('black','red')
names(cols) = c(0,1)
it=plot(njtree, align.tip.label=TRUE, cex=.5, label.offset = .0002, 
       tip.color = cols[as.character(cmtstop[njtree$tip.label,2])])
tiplabels(thermo = unlist(genos['76533',njtree$tip.label]) / max(genos['76533',njtree$tip.label],na.rm=TRUE),
          horiz=TRUE, bg='none', cex=.4)

h=haplotype(dna)
h=sort(h, what='label')
net = haploNet(h)

ind.hap<-with(
   stack(setNames(attr(h, "index"), rownames(h))),
   table(hap=ind, pop=rownames(dna)[values])
   )

plot(net, size=attr(net, "freq"), scale.ratio=0.2, pie=ind.hap, labels=FALSE)
#legend(-12, -4, colnames(ind.hap), col=rainbow(ncol(ind.hap)), pch=19, ncol=1)
legend(-100, 170, colnames(ind.hap), col=rainbow(ncol(ind.hap)), pch=19, ncol=1,cex=.5)

# dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/edr1_noaly_mafft.clustal', format='clustal')
# #dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/consens_align.clustal', format='clustal')
# #dna = read.dna('~/Dropbox/bioinformatics/1665_haplos_more.clustal',format='clustal')
# e=dist.dna(dna) # not used?
# ts = dist.dna(dna, model='TS')
# 
# h=haplotype(dna)
# h=sort(h, what='label')
# net = haploNet(h)
# 
# ind.hap<-with(
#   stack(setNames(attr(h, "index"), rownames(h))),
#   table(hap=ind, pop=rownames(dna)[values])
# )
# 
# plot(net, size=attr(net, "freq"), scale.ratio=0.2, pie=ind.hap)
# #legend(-12, -4, colnames(ind.hap), col=rainbow(ncol(ind.hap)), pch=19, ncol=1)
# legend(-7, -2, colnames(ind.hap), col=rainbow(ncol(ind.hap)), pch=19, ncol=1,cex=.5)
# 
# library(adegenet)
# polys = DNAbin2genind(dna)
# 
# poly_tab = polys@tab
