# make cmt2 plots + inference
cmtstop = read.csv('validations/cmt2_stops.csv',header=T)
rownames(cmtstop) = cmtstop[,1]
beeswarm(unlist(genos['76533',as.vector(cmtstop[,1])]) ~ cmtstop[,2], pch=19, ylab='CMT2 STR copy number\n(STR 76533)', xlab='Has CMT2 nonsense mutation')

require(pegas)
require(ape)
dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/cmt2_gene_seq_in96.clustal', format='clustal')
e=dist.dna(dna) # not used?
njtree = nj(e)

cols = c('black','red')
names(cols) = c(0,1)
#par(mfrow=c(1,2))
it=plot(njtree, align.tip.label=TRUE, cex=.5, label.offset = .0001, 
     tip.color = cols[as.character(cmtstop[njtree$tip.label,2])])
tiplabels(thermo = unlist(genos['76533',njtree$tip.label]) / max(genos['76533',njtree$tip.label],na.rm=TRUE),horiz=TRUE,bg='none',cex=.5)
barplot(unlist(genos['76533',njtree$tip.label]), horiz=TRUE,las=2,cex.names =.5, xlab='CMT2 STR copy number')
par(mfrow=c(1,1))
h=haplotype(dna)
h=sort(h, what='label')
net = haploNet(h)

ind.hap<-with(
  stack(setNames(attr(h, "index"), rownames(h))),
  table(hap=ind, pop=rownames(dna)[values])
)

plot(net, size=attr(net, "freq"), scale.ratio=0.2, pie=ind.hap, labels=FALSE)
#legend(-12, -4, colnames(ind.hap), col=rainbow(ncol(ind.hap)), pch=19, ncol=1)
legend(-100, 170, colnames(ind.hap), col=rainbow(ncol(ind.hap)), pch=19, ncol=1,cex=.5)