# chop-qpcr
pcr = read.table('../AthMIP_deadends/mop_050317_chop_pcr.txt',header=T,sep='\t')

ddCt = function(both,...) {
  #print(both)
  # throw out failed rxns
  test = as.numeric(na.omit(both[,1]))
  ref = as.numeric(na.omit(both[,2]))
  #print(rbind(test,ref))
  
  meanT = mean(test)
  sdT = sd(test) / sqrt(length(test))
  meanR = mean(ref)
  sdR = sd(ref) / sqrt(length(test))
  
  dCt = meanR - meanT
  sdCt = sqrt(sdT+sdR)
  
  ddCt_mean = 2^(dCt)
  # sd bounds
  ddCt_upper = 2^(dCt+sdCt)
  ddCt_lower = 2^(dCt-sdCt)
  
  out = c(ddCt_mean,ddCt_upper,ddCt_lower)
  names(out) = c('mean','upper','lower')
  return(out)
  
}

# assuming 456 is con for 123 and 101112 for 456
out = matrix(rep(NA,16),8)
rownames(out) = unique(pcr$Row)
for (row in unique(pcr$Row)) {
  print(row)
   geno = pcr[pcr$Row==row,]

    to_process = cbind(geno[geno$Col %in% 1:3,'Cp'],geno[geno$Col %in% 7:9,'Cp'])
  out[row,1] = ddCt(to_process)[1]
  to_process = cbind(geno[geno$Col %in% 4:6,'Cp'],geno[geno$Col %in% 10:12,'Cp'])
  out[row,2] = ddCt(to_process)[1]
}