# make haplo net for str 1665 and EDR1 
require(pegas)
require(ape)
#dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/consens_align_noaly.clustal', format='clustal')
#dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/edr1_mafft.clustal', format='clustal')
#dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/consens_align.clustal', format='clustal')
#dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/edr1_mafft.clustal', format='clustal')
dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/consensi_050817.clustal',format='clustal')
e=dist.dna(dna) # not used?
ts = dist.dna(dna, model='TS')

h=haplotype(dna)
h=sort(h, what='label')
net = haploNet(h, d = ts)

ind.hap<-with(
   stack(setNames(attr(h, "index"), rownames(h))),
   table(hap=ind, pop=rownames(dna)[values])
   )

plot(net, threshold=c(1,10), show.mutation=FALSE,  size=attr(net, "freq"), scale.ratio=0.2, pie=ind.hap)
#legend(-12, -4, colnames(ind.hap), col=rainbow(ncol(ind.hap)), pch=19, ncol=1)
legend(-30, 20, colnames(ind.hap), col=rainbow(ncol(ind.hap)), pch=19, ncol=1,cex=.5)

dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/consensi_050817_noaly.clustal', format='clustal')
#dna = read.dna('~/Dropbox/Ath_STRs/selection_analysis/str_fst_analysis/EDR1_seq_040417/consens_align.clustal', format='clustal')
#dna = read.dna('~/Dropbox/bioinformatics/1665_haplos_more.clustal',format='clustal')
e=dist.dna(dna) 
noaly_nj = nj(e)
plot(noaly_nj, label.offset=.0005, type='phylogram', align.tip.label=TRUE)
tiplabels(bg = allele_cols, text=' ')

h=haplotype(dna)
h=sort(h, what='label')
net = haploNet(h)

ind.hap<-with(
  stack(setNames(attr(h, "index"), rownames(h))),
  table(hap=ind, pop=rownames(dna)[values])
)


rain = rainbow(3)
names(rain) = c(7,8,9)
allele_cols = c(
  rain[as.character(genos['1665', 'Ag-0'])],
  rain[as.character(genos['1665', 'Bay-0'])],
  rain[as.character(genos['1665', 'Bur-0'])],
  rain['8'], # Car-1
  rain[as.character(genos['1665', 'Est-1'])],
  rain[as.character(genos['1665', 'Gu-0'])],
  rain[as.character(genos['1665', 'Kas-2'])],
  rain[as.character(genos['1665', 'Kondara'])],
  rain['9'], # Lin
  rain[as.character(genos['1665', 'Nok-3'])],
  rain['9'], # Ost-0
  rain['8'], # Pi-0
  rain[as.character(genos['1665', 'Sha'])],
  rain[as.character(genos['1665', 'Tsu-1'])],
  rain[as.character(genos['1665', 'Wei-0'])],
  rain[as.character(genos['1665', 'Yo-0'])],
  rain['7'], # Zal-1
  rain[as.character(genos['1665', 'Ws-2'])],
  rain[as.character(genos['1665', 'Col'])]
)

names(allele_cols) = rownames(dna)

#plot(net, threshold=c(1,10), show.mutation=FALSE, size=attr(net, "freq"), scale.ratio=0.2, pie=ind.hap)
plot(net, threshold=c(1,10), show.mutation=FALSE, size=attr(net, "freq"), scale.ratio=0.2, col=allele_cols[colnames(ind.hap)], pie=ind.hap)
#legend(-12, -4, colnames(ind.hap), col=rainbow(ncol(ind.hap)), pch=19, ncol=1)
legend(-15, 10, colnames(ind.hap), col=rainbow(ncol(ind.hap)), pch=19, ncol=1,cex=.5)


#plot()

library(adegenet)
polys = DNAbin2genind(dna)

poly_tab = polys@tab
