#!usr/bin/Rscript

str = commandArgs(trailingOnly=TRUE)[1]
lds_in = commandArgs(trailingOnly=TRUE)[2]

if (length(commandArgs(trailingOnly=TRUE)) == 3) {
	windowsize = as.numeric(commandArgs(trailingOnly=TRUE)[3])
	} else {
	windowsize=FALSE
	}	
print(windowsize)

lds = read.table(lds_in, header=T)
lds = lds[lds$loc1 == str | lds$loc2 == str,]

left = lds[lds$loc1 == str,]
coords = left$pos2
all = cbind(coords, left$r)
str_coord = left$pos1[1]

right = lds[lds$loc2 == str,]
coords = right$pos1

all = rbind(all, cbind(coords, right$r))

pdf(paste(str,'pdf',sep='.'))
if (windowsize) {
plot(all, xlab = 'Coordinate (bp)',ylab='R',cex=.5, main=str, xlim=c(str_coord-windowsize,str_coord+windowsize))
} else {
plot(all, xlab = 'Coordinate (bp)',ylab='R',cex=.5, main=str )
}
abline(v=str_coord)
dev.off()

