#!usr/bin/Rscript

chr = commandArgs(trailingOnly=TRUE)[1]
strs = readLines('str_locs.txt') # strs whose location i want plotted


ld_ests = read.table(paste('mcld_processed_chr',chr,'.txt',sep=''),header=T)

lowed = lowess(ld_ests$r^2, f=0.01)
strs = unique(ld_ests$loc2[ld_ests$loc2 %in% strs])

pdf(paste('chr',chr,'ld_str_plot.pdf',sep='_'))
plot(lowed, type='l', ylim = c(0,.6), xlab='Loci',ylab='Linkage disequilibrium (R)', main=paste('Chromosome',chr))
for (str in strs) {
	print(str)
	locs = which(ld_ests$loc2 == str)
	rug(locs)
	}
dev.off()
