# Readme for LD analysis of STR linkage disequilibrium analyses
### press et al. (in prep).

You will find the following directories/files in this directory:

1. `code` (dir): contains code for analysis

2. `mcld.exe` (executable file): the MCLD program described in Zaykin et al. (2008). This executable is compiled under Linux and will not work in other operating systems.

3. `str_snp_genos_for_mcld.Rdat` (R data file): genotypes for SNP and STR loci across 96 strains analyzed here. SNP array genotypes are TAIR9 from the [RegMap project](http://bergelson.uchicago.edu/?page_id=790#regmap). STRs are from the present study, generated by MIP capture and sequencing.

4. `all_ld_ests_020217.Rdat` (R data file): LD estimates output by this analysis.

Other files will populate this directory during analysis, but I will not treat them here.

To run this analysis and generate plots:

0) Preprocess SNP and STR data into a single data object (i.e. `str_snp_genos_for_mcld.Rdat`) that is easy to work with. Script:  `code/preprocess_str_snp_LD_data_012417.R`. Not necessary, already have data file, and will not run unless you go download the TAIR9 RegMap data and put it in this dir.

1) Run data by chromosomes through MCLD. Take the tabular genotype data, chunk it for processing by MCLD, run chunks through MCLD, combine chunks into a single processed dataset per chromosome. Script: `code/run_windows_through_mcld.R`, can be run like:

```
$ Rscript code/run_windows_through_mcld.R 1 # runs Chr1 only
```

All chromosomes can be run at the same time with a shell script such as `code/run_windows_mcld.sh`. 

*note that this is a Linux-compiled MCLD executable file and you may need to obtain a different executable for your system.

2) Combine data across chromosomes, filter it by some criteria, and generate plots of smoothed LD estimates by STR and SNP. Script: `code/cat_and_plot_mcld_outs.R`. Run:

```
# generates plot filtering out all LD R^2 measurements less than 0.05.
$ Rscript code/cat_and_plot_mcld_outs.R 0.05 
```

