% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonal_deletion_detection.R
\name{trimSnps}
\alias{trimSnps}
\title{Function to filter out SNPs from ExAC database}
\usage{
trimSnps(vcf, maft = 0.1)
}
\arguments{
\item{vcf}{readVcf object from ExAC database read over a certain range}

\item{maft}{minor allele frequency cutoff for filtering}
}
\value{
snps GenomicRanges object with positions of putative heterozygous SNPs
  info data fram with metadata for putative heterozygous SNPs
}
\description{
Function to filter out SNPs from ExAC database
}
\examples{
\dontrun{
vcfFile <- "../data-raw/ExAC.r0.3.sites.vep.vcf.gz"
# Filter for SNPs over all of chr1	
testRanges <- GRanges(seqnames='1', IRanges(start = 0, width=249250621))
param = ScanVcfParam(which=testRanges)
vcf <- readVcf(vcfFile, "hg19", param=param)
temp <- trimSnps(vcf)
snps <- temp$snps
info <- temp$info
head(info)
head(snps)
}

}
