% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoneyBADGER_gexp.R
\name{setGexpMats}
\alias{setGexpMats}
\title{Functions related to gene expression model
Set gene expression matrices, normalizes, and maps genes to genomic coordinates}
\usage{
setGexpMats(gexp.sc.init, gexp.ref.init, mart.obj, filter = TRUE,
  minMeanBoth = 0, minMeanTest = mean(gexp.sc.init[gexp.sc.init != 0]),
  minMeanRef = mean(gexp.ref.init[gexp.ref.init != 0]), scale = TRUE,
  id = "hgnc_symbol", verbose = TRUE)
}
\arguments{
\item{gexp.sc.init}{Single cell gene expression matrix}

\item{gexp.ref.init}{Reference gene expression matrix such as from GTEX or a match normal}

\item{mart.obj}{Biomart object used for mapping genes to genomic positions}

\item{filter}{Boolean of whether or not to filter genes (default: TRUE)}

\item{minMeanBoth}{Minimum mean gene expression in both the single cell and reference matrices (default: 4.5)}

\item{minMeanTest}{Minimum mean gene expression for the single cell expression matrix (default: 6)}

\item{minMeanRef}{Minimum mean gene expression for the reference expression matrix (default: 8)}

\item{scale}{Boolean of whether or not to scale by library size (default: TRUE)}

\item{id}{biomaRt ID for genes c(default: 'hgnc_symbol')}

\item{verbose}{Verbosity (default: TRUE)}
}
\description{
Functions related to gene expression model
Set gene expression matrices, normalizes, and maps genes to genomic coordinates
}
\examples{
data(gexp)
data(ref)
require(biomaRt) ## for gene coordinates
mart.obj <- useMart(biomart = "ENSEMBL_MART_ENSEMBL", 
   dataset = 'hsapiens_gene_ensembl', 
   host = "jul2015.archive.ensembl.org")
gexp.mats <- setGexpMats(gexp, ref, mart.obj, filter=FALSE, scale=FALSE)

}
