% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoneyBADGER_gexp.R
\name{setGexpDev}
\alias{setGexpDev}
\title{Set needed absolute gene expression deviance to be able to distinguish neutral from amplified or deletion regions}
\usage{
setGexpDev(gexp.norm, alpha = 0.25, n = 100, seed = 0, plot = FALSE,
  verbose = FALSE)
}
\arguments{
\item{gexp.norm}{Normalized gene expression matrix}

\item{alpha}{Alpha level (default: 0.05)}

\item{n}{Number of repeats for estimating parameter (default: 100)}

\item{seed}{Random seed}

\item{plot}{Plotting}

\item{verbose}{Verbosity}
}
\description{
Set needed absolute gene expression deviance to be able to distinguish neutral from amplified or deletion regions
}
\examples{
data(gexp)
data(ref)
require(biomaRt) ## for gene coordinates
mart.obj <- useMart(biomart = "ENSEMBL_MART_ENSEMBL", 
    dataset = 'hsapiens_gene_ensembl', 
    host = "jul2015.archive.ensembl.org")
gexp.mats <- setGexpMats(gexp, ref, mart.obj, filter=FALSE, scale=FALSE)
dev <- setGexpDev(gexp.mats$gexp.norm)

}
