% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoneyBADGER_allele.R
\name{setGeneFactors}
\alias{setGeneFactors}
\title{Maps snps to genes}
\usage{
setGeneFactors(snps, txdb, fill = TRUE, verbose = TRUE)
}
\arguments{
\item{snps}{SNP annotations}

\item{txdb}{TxDb object (ex. TxDb.Hsapiens.UCSC.hg19.knownGene).}

\item{fill}{SNPs mapping to genes not annotated in txdb will be given unique IDs}

\item{verbose}{Verbosity}
}
\description{
Maps snps to genes
}
\examples{
data(r)
data(cov.sc)
allele.mats <- setAlleleMats(r, cov.sc)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
geneFactor <- setGeneFactors(allele.mats$snps, TxDb.Hsapiens.UCSC.hg19.knownGene)

}
