% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoneyBADGER_allele.R
\name{setAlleleMats}
\alias{setAlleleMats}
\title{Functions related to allele model
Set allele count matrices, creates in-silico pooled single cells as bulk reference if none provided}
\usage{
setAlleleMats(r.init, n.sc.init, l.init = NULL, n.bulk.init = NULL,
  filter = TRUE, het.deviance.threshold = 0.05, min.cell = 3,
  n.cores = 1, verbose = TRUE)
}
\arguments{
\item{r.init}{SNP site alternate allele count matrix for single cells}

\item{n.sc.init}{SNP site coverage count matrix for single cells}

\item{l.init}{SNP site alternate allele counts for bulk reference. If NULL, in silico bulk will be created from single cells.}

\item{n.bulk.init}{SNP site coverage counts for bulk reference. If NULL, in silico bulk will be created from single cells.}

\item{filter}{Whether to filter SNPs to only putative hterozygous SNPs based on the het.deviance.threshold}

\item{het.deviance.threshold}{Deviation from expected 0.5 heterozygous fraction}

\item{min.cell}{Minimum number of cells a SNP must have coverage observed in}

\item{n.cores}{Number of cores}

\item{verbose}{Verbosity}
}
\description{
Functions related to allele model
Set allele count matrices, creates in-silico pooled single cells as bulk reference if none provided
}
\examples{
data(r)
data(cov.sc)
allele.mats <- setAlleleMats(r, cov.sc)

}
