% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoneyBADGER_allele.R
\name{plotAlleleProfile}
\alias{plotAlleleProfile}
\title{Plot allele profile}
\usage{
plotAlleleProfile(r.maf, n.sc, l.maf, n.bulk, snps, region = NULL,
  chrs = paste0("chr", c(1:22)), widths = NULL, cellOrder = NULL,
  filter = FALSE, max.ps = 3, verbose = FALSE)
}
\arguments{
\item{r.maf}{SNP lesser allele count matrix for single cells.}

\item{n.sc}{SNP coverage count matrix for single cells.}

\item{l.maf}{SNP lesser allele count matrix for bulk refernece.}

\item{n.bulk}{SNP coverage count matrix for bulk refernece.}

\item{snps}{SNP annotations}

\item{region}{Limit plotting to particular GenomicRanges regions}

\item{chrs}{Limit plotting to select chromosomes. Default autosomes only. (default: paste0('chr', c(1:22)))}

\item{widths}{Widths of chromosomes in plot. If 'set' will depend on number of SNPs in region. Else will be equal.}

\item{cellOrder}{Order of cells. If 'set' will be automatically ordered by clustering. Else will be same order as input.}

\item{filter}{Remove sites with no coverage}

\item{max.ps}{Maximum point size for plot.}

\item{verbose}{Verbosity}
}
\description{
Plot allele profile
}
\examples{
data(r)
data(cov.sc)
allele.mats <- setAlleleMats(r, cov.sc)
plotAlleleProfile(allele.mats$r.maf, allele.mats$n.sc, 
    allele.mats$l.maf, allele.mats$n.bulk, allele.mats$snps, 
    widths=c(249250621, 243199373, 198022430, 191154276, 180915260, 
    171115067, 159138663, 146364022, 141213431, 135534747, 135006516, 
    133851895, 115169878, 107349540, 102531392, 90354753, 81195210, 
    78077248, 59128983, 63025520, 51304566, 48129895)/1e7) 

}
