% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonal_deletion_detection.R
\name{isHetAlt}
\alias{isHetAlt}
\title{Alternate helper function to determine heterzogosity at a position from allele  
counts. Returns TRUE for heterozygous SNPs, FALSE otherwise based on coverage.
If only reads are recorded from reference allele, then SNP is automatically
classified as homozygous.
If reads from both alleles or just the alternate allele are recorded, then the
hypothesis test is applied}
\usage{
isHetAlt(cov, t = 1e-08)
}
\arguments{
\item{cov}{vector of allele counts and coverage for a putative heterozygous SNP}

\item{t}{threshold for hypothesis testing for heterozygosity, default 1e-8
(Illumina sequencing error rate)}
}
\value{
Boolean - TRUE for heterozygous, FALSE for homozygous
}
\description{
Alternate helper function to determine heterzogosity at a position from allele  
counts. Returns TRUE for heterozygous SNPs, FALSE otherwise based on coverage.
If only reads are recorded from reference allele, then SNP is automatically
classified as homozygous.
If reads from both alleles or just the alternate allele are recorded, then the
hypothesis test is applied
}
\examples{
\dontrun{
}

}
