% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clonal_deletion_detection.R
\name{isHet}
\alias{isHet}
\title{Helper function to determine heterzogosity at a position from allele counts 
Returns TRUE for heterozygous SNPs, FALSE otherwise based on coverage
If reads are recorded from only one of reference or alternate allele, then it is
automakically classified as homozygous
If reads from both alleles are recorded, then we adopt a null hypothesis that
the number of minor allele reads sequenced is distributed  according to
Binomial(p = 0.5, n), where n is the total read depth at that position. SNPs at
which the null hypothesis p = 0.5 was rejected were classified as homozygous,
while the remainder were classified as heterozygous.}
\usage{
isHet(cov, t = 1e-08)
}
\arguments{
\item{cov}{vector of allele counts and coverage for a putative heterozygous SNP}

\item{t}{threshold for hypothesis testing for heterozygosity, default 1e-8
(Illumina sequencing error rate)}
}
\value{
Boolean - TRUE for heterozygous, FALSE for homozygous
}
\description{
Helper function to determine heterzogosity at a position from allele counts 
Returns TRUE for heterozygous SNPs, FALSE otherwise based on coverage
If reads are recorded from only one of reference or alternate allele, then it is
automakically classified as homozygous
If reads from both alleles are recorded, then we adopt a null hypothesis that
the number of minor allele reads sequenced is distributed  according to
Binomial(p = 0.5, n), where n is the total read depth at that position. SNPs at
which the null hypothesis p = 0.5 was rejected were classified as homozygous,
while the remainder were classified as heterozygous.
}
\examples{
\dontrun{
}

}
