% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareData.R
\name{getSnpMats}
\alias{getSnpMats}
\title{Helper function to get coverage and allele count matrices given a set of putative heterozygous SNP positions}
\usage{
getSnpMats(snps, bamFiles, indexFiles, n.cores = 1, verbose = FALSE)
}
\arguments{
\item{snps}{GenomicRanges object for positions of interest}

\item{bamFiles}{list of bam file}

\item{indexFiles}{list of bai index file}

\item{n.cores}{number of cores}

\item{verbose}{Boolean of whether or not to print progress and info}
}
\value{
refCount reference allele count matrix for each cell and each position of interest
  altCount alternative allele count matrix for each cell and each position of interest
  cov total coverage count matrix for each cell and each position of interest
}
\description{
Helper function to get coverage and allele count matrices given a set of putative heterozygous SNP positions
}
\examples{
\dontrun{
# Get putative hets from ExAC
vcfFile <- "../data-raw/ExAC.r0.3.sites.vep.vcf.gz"
testRanges <- GRanges(chr, IRanges(start = 1, width=1000))
param = ScanVcfParam(which=testRanges)
vcf <- readVcf(vcfFile, "hg19", param=param)
## common snps by MAF
info <- info(vcf)
if(nrow(info)==0) {
    if(verbose) {
        print("ERROR no row in vcf")
    }
    return(NA)
}
maf <- info[, 'AF'] # AF is Integer allele frequency for each Alt allele
if(verbose) {
    print(paste0("Filtering to snps with maf > ", maft))
}
vi <- sapply(maf, function(x) any(x > maft))
if(verbose) {
    print(table(vi))
}
snps <- rowData(vcf)
snps <- snps[vi,]
## get rid of non single nucleotide changes
vi <- width(snps@elementMetadata$REF) == 1
snps <- snps[vi,]
## also gets rid of sites with multiple alt alleles though...hard to know which is in our patient
vi <- width(snps@elementMetadata$ALT@partitioning) == 1
snps <- snps[vi,]
## Get bams
files <- list.files(path = "../data-raw")
bamFiles <- files[grepl('.bam$', files)]
bamFiles <- paste0(path, bamFiles)
indexFiles <- files[grepl('.bai$', files)]
indexFiles <- paste0(path, indexFiles)
results <- getSnpMats(snps, bamFiles, indexFiles)
}

}
