% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareData.R
\name{getCoverage}
\alias{getCoverage}
\title{Get coverage count for positions of interest}
\usage{
getCoverage(gr, bamFile, indexFile, verbose = FALSE)
}
\arguments{
\item{gr}{GenomicRanges object for positions of interest}

\item{bamFile}{bam file}

\item{indexFile}{bai index file}

\item{verbose}{Boolean of whether or not to print progress and info}
}
\value{
totCount Total coverage count information for each position of interest
}
\description{
Get coverage count for positions of interest
}
\examples{
\dontrun{
# Sites of interest (chr1:4600000, chr2:2000)
gr <- GRanges(c('chr1', 'chr2'), IRanges(start=c(4600000, 2000), width=1))
# we can get the coverage at these SNP sites from our bams
path <- '../data-raw/bams/'
files <- list.files(path = path)
files <- files[grepl('.bam$', files)]
cov <- do.call(cbind, lapply(files, function(f) {
    bamFile <- paste0(path, f)
    indexFile <- paste0(path, paste0(f, '.bai'))
    getCoverage(gr, bamFile, indexFile)
}))
colnames(cov) <- files
}

}
