% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareData.R
\name{getAlleleCount}
\alias{getAlleleCount}
\title{Get alternative allele count for positions of interest}
\usage{
getAlleleCount(gr, bamFile, indexFile, verbose = FALSE)
}
\arguments{
\item{gr}{GenomicRanges object for positions of interest}

\item{bamFile}{bam file}

\item{indexFile}{bai index file}

\item{verbose}{Boolean of whether or not to print progress and info}
}
\value{
refCount reference allele count information for each position of interest
  altCount alternative allele count information for each position of interest
}
\description{
Get alternative allele count for positions of interest
}
\examples{
\dontrun{
# Sites of interest (chr1:4600000, chr2:2000)
gr <- GRanges(c('chr1', 'chr2'), IRanges(start=c(4600000, 2000), width=1))
# we can get the coverage at these SNP sites from our bams
path <- '../data-raw/bams/'
files <- list.files(path = path)
files <- files[grepl('.bam$', files)]
alleleCounts <- lapply(files, function(f) {
   bamFile <- paste0(path, f)
   indexFile <- paste0(path, paste0(f, '.bai'))
   getAlleleCount(gr, bamFile, indexFile)
})
altCounts <- do.call(cbind, lapply(1:length(gr), function(i) alleleCounts[[i]][[1]]))
refCounts <- do.call(cbind, lapply(1:length(gr), function(i) alleleCounts[[i]][[2]]))
colnames(altCounts) <- colnames(refCounts) <- files
}

}
