% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoneyBADGER_gexp.R
\name{calcGexpCnvProb}
\alias{calcGexpCnvProb}
\title{Calculate posterior probability of CNVs using normalized expression data}
\usage{
calcGexpCnvProb(gexp.norm, genes, mvFit, m = 0.15, region = NULL,
  verbose = FALSE)
}
\arguments{
\item{gexp.norm}{Normalized gene expression matrix.}

\item{genes}{GRanges annotation of gene names and coordinates}

\item{mvFit}{Mean variance fit}

\item{m}{Expression deviation due to copy number change (default: 0.15)}

\item{region}{Optional GenomicRanges region of interest such as expected CNV boundaries. (default: NULL)}

\item{verbose}{Verbosity (default: FALSE)}
}
\description{
Calculate posterior probability of CNVs using normalized expression data
}
\examples{
data(gexp)
data(ref)
require(biomaRt) ## for gene coordinates
mart.obj <- useMart(biomart = "ENSEMBL_MART_ENSEMBL", 
    dataset = 'hsapiens_gene_ensembl', 
    host = "jul2015.archive.ensembl.org")
gexp.mats <- setGexpMats(gexp, ref, mart.obj, filter=FALSE, scale=FALSE)
mvFit <- setMvFit(gexp.mats$gexp.norm)
results <- calcGexpCnvProb(gexp.mats$gexp.norm, gexp.mats$genes, 
    mvFit, region=GenomicRanges::GRanges('chr10', IRanges::IRanges(0,1e9)), verbose=TRUE)

}
