% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoneyBADGER_comb.R
\name{calcCombCnvProb}
\alias{calcCombCnvProb}
\title{Calculate posterior probability of CNVs using normalized expression data and allele data}
\usage{
calcCombCnvProb(gexp.norm, genes, mvFit, m = 0.15, r.maf, n.sc, l.maf, n.bulk,
  snps, geneFactor, region = NULL, filter = FALSE, pe = 0.1, mono = 0.7,
  verbose = FALSE)
}
\arguments{
\item{gexp.norm}{Normalized gene expression matrix.}

\item{genes}{GRanges annotation of gene names and coordinates}

\item{mvFit}{Mean variance fit}

\item{m}{Expression deviation due to copy number change (default: 0.15)}

\item{r.maf}{Matrix of alt allele count in single cells.}

\item{n.sc}{Matrix of site coverage count in single cells.}

\item{l.maf}{Vector of alt allele count in pooled single cells or bulk.}

\item{n.bulk}{Vector of site coverage count in pooled single cells or bulk.}

\item{snps}{SNP annotations}

\item{geneFactor}{Output of \code{\link{setGeneFactors}}}

\item{region}{Optional GenomicRanges region of interest such as expected CNV boundaries. (default: NULL)}

\item{filter}{Boolean for whether to filter out SNP sites with no coverage. (default: TRUE)}

\item{pe}{Effective error rate to capture error from sequencing, etc. (default: 0.01)}

\item{mono}{Rate of mono-allelic expression. (default: 0.7)}

\item{verbose}{Verbosity (default: FALSE)}
}
\description{
Calculate posterior probability of CNVs using normalized expression data and allele data
}
