% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoneyBADGER_allele.R
\name{calcAlleleCnvBoundaries}
\alias{calcAlleleCnvBoundaries}
\title{Use HMM to identify potential CNV boundaries based on patterns of persistent allelic imbalance}
\usage{
calcAlleleCnvBoundaries(r.maf, n.sc, l.maf, n.bulk, snps, geneFactor,
  min.traverse = 3, t = 1e-06, pd = 0.1, pn = 0.45, min.num.snps = 5,
  trim = 0.1, verbose = FALSE, ...)
}
\arguments{
\item{r.maf}{Matrix of alt allele count in single cells.}

\item{n.sc}{Matrix of site coverage count in single cells.}

\item{l.maf}{Vector of alt allele count in pooled single cells or bulk.}

\item{n.bulk}{Vector of site coverage count in pooled single cells or bulk.}

\item{snps}{SNP annotations}

\item{geneFactor}{Output of \code{\link{setGeneFactors}}}

\item{min.traverse}{Depth traversal to look for subclonal CNVs. Higher depth, potentially smaller subclones detectable. (default: 3)}

\item{t}{HMM transition parameter. Higher number, more transitions. (default: 1e-6)}

\item{pd}{Probability of lesser allele detection in deleted region (ie. due to error)}

\item{pn}{Probability of lesser allele detection in neutral region (ie. 0.5 - error rate)}

\item{min.num.snps}{Minimum number of snps in candidate CNV}

\item{trim}{Trim boundary SNPs}

\item{verbose}{Verbosity(default: FALSE)}

\item{...}{Additional parameters to pass to calcAlleleCnvProb}
}
\description{
Use HMM to identify potential CNV boundaries based on patterns of persistent allelic imbalance
}
\examples{
{
data(r)
data(cov.sc)
allele.mats <- setAlleleMats(r, cov.sc)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
geneFactor <- setGeneFactors(allele.mats$snps, TxDb.Hsapiens.UCSC.hg19.knownGene)
potentialCnvs <- calcAlleleCnvBoundaries(allele.mats$r.maf, allele.mats$n.sc, 
    allele.mats$l.maf, allele.mats$n.bulk, allele.mats$snps, geneFactor)
## visualize affected regions
plotAlleleProfile(allele.mats$r.maf, allele.mats$n.sc, allele.mats$l.maf, 
    allele.mats$n.bulk, allele.mats$snps, region=potentialCnvs$region)
}

}
