% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoneyBADGER.R
\name{HoneyBADGER_plotGexpProfile}
\alias{HoneyBADGER_plotGexpProfile}
\title{Plot gene expression profile}
\arguments{
\item{gexp.norm.sub}{Optional normalized gene expression matrix. If not provided, internal normalized gene expression matrix is used.}

\item{chrs}{Chromosomes to be plotted (default: paste0('chr', c(1:22, 'X')))}

\item{window.size}{Window size for sliding window mean. Must be odd number. (default: 101)}

\item{zlim}{Limit for plotting heatmap (default: c(-2,2))}

\item{setOrder}{Boolean for whether or not to order cells (default: FALSE)}

\item{setWidths}{Boolean for whether or not to adjust widths of chomosomes based on number of genes. Otherwise uniform size. (default: FALSE)}

\item{order}{Order of cells (default: NULL)}

\item{defailt}{Boolean for whether to return detailed smoothed profiles (default: FALSE)}
}
\description{
Plot gene expression profile
}
\examples{
data(gexp)
data(ref)
require(biomaRt) ## for gene coordinates
mart.obj <- useMart(biomart = "ENSEMBL_MART_ENSEMBL", 
    dataset = 'hsapiens_gene_ensembl', 
    host = "jul2015.archive.ensembl.org")
hb <- HoneyBADGER$new()
hb$setGexpMats(gexp, ref, mart.obj, filter=FALSE, scale=FALSE)
hb$plotGexpProfile() 

}
