% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HoneyBADGER.R
\docType{class}
\name{HoneyBADGER-class}
\alias{HoneyBADGER-class}
\alias{HoneyBADGER}
\title{A Reference Class to represent single-cell RNA-seq data for HoneyBADGER analysis}
\description{
A Reference Class to represent single-cell RNA-seq data for HoneyBADGER analysis
}
\section{Fields}{

\describe{
\item{\code{r}}{single cell alternative allele count matrix}

\item{\code{n.sc}}{single cell snp coverage matrix}

\item{\code{l}}{bulk alternative allele count vector}

\item{\code{n.bulk}}{bulk snp coverage vector}

\item{\code{r.maf}}{single cell lesser allele count matrix}

\item{\code{l.maf}}{bulk lesser allele count vector}

\item{\code{gexp.sc}}{gene expression matrix}

\item{\code{gexp.ref}}{reference gene expression matrix}

\item{\code{gexp.norm}}{normalized gene expression matrix}

\item{\code{mvFit}}{estimated expression magnitude variance as a function of number of genes}

\item{\code{dev}}{expected absolute gene expression deviance due to CNV}

\item{\code{snps}}{GenomicRanges representation of snps in r}

\item{\code{genes}}{GenomicRanges representation of gene positions for genes in gexp.sc}

\item{\code{geneFactor}}{mapping of snps to genes}

\item{\code{pred.snps.r}}{matrix of cells and snps affected by cnv}

\item{\code{pred.genes.r}}{matrix of cells and snps affected by cnv}

\item{\code{bound.snps.old}}{temporary list of snps within cnv region used during recursion}

\item{\code{bound.snps.final}}{list of snps within cnv region}

\item{\code{bound.genes.old}}{temporary list of snps within cnv region used during recursion}

\item{\code{bound.genes.final}}{list of snps within cnv region}

\item{\code{results}}{retested posterior probabilities}

\item{\code{summary}}{summary of posterior probabilities}

\item{\code{cnvs}}{GenomicRanges of identified CNVs}
}}


