#==========================================
# (C) Copyright 2017, by LDGH and Contributors.
#
# -----------------
#  Master Script to perform haplotyping and imputation analysis
#  -----------------
#
# Original Author: Thiago Peixoto Leal (thpeixotol@hotmail.com)
#
# Description: This Masterscript peform haplotyping and imputation analysis (including creating and merging panels).
#
# Dependencies:
#	Perl interpreter
#
# # Parameters:
#	-input: File with data description
#	-output: Folder where results will be saved 
#	-path: File with programs path
#	-start: First chromossome of interval
#	-end: Last chromossome of interval
#	-seed: Seed of shapeit (optional)
#	-states: States of shapeit (optional)
#	-bed: This option tells the algorithm that the data is in the bed/bim/fam format (ped/map is the default)
#	
# Outputs: 
#	The outputs are present in the folder specified in the -output parameter. These are the *.impute2, *.impute2_info,
#	 *.impute2_summary, *.impute2_info_by_sample, and *.impute2_warnings files.
#  
# We use 8 threads for phase with shapeit and imputation process.
# 
#
# Please, check for updated version at "http://www.ldgh.com.br/scientificworkflow/index.html"
#===========================================



#!/usr/bin/perl
use strict;
use FileHandle;
use Getopt::Long;
use Data::Dumper;
use threads;

our ($help, $imputation, $teste, $input, $output, $print, $start, $end, $programsPath, $chr, $lower, $higher, $threads, $count, $temp, $flag, $flag2, $temp2, $flag1000G, $m, $concluido, 
$only, $threadsImputation, $dontImpute);
our ($seed, $states, $bed);
our (@listExclude, @buffer, @vectorTemp, @vectorTemp2);
our (%hash, %path, %panels);


GetOptions (
	"help!"=>\$help,
	"input=s"=>\$input,
	"output=s"=>\$output,
	"start=s"=>\$start,
	"path=s"=>\$programsPath,
	"end=s"=>\$end,
	"test"=>\$teste,
	"print"=>\$print,
	"seed=s"=>\$seed,
	"states=s"=>\$states,
	"bed"=>\$bed,
#	"only"=>\$only,
)or die(showHelp());

if($help or $input eq "" or $output eq "" or $programsPath eq "" or $start eq "" or $end eq ""){
	showHelp();
}

my($z);

foreach $chr ($start..$end){
	undef(%hash);
	$threads=8;
	$imputation=0;

	print "Step 1\n"; #Open File 1
	readInputFile();

	print "Step 2\n"; #Open file 2
	readScriptsFile();
	
	if($bed != 1){
		print "Step 3\n";
		findHigherAndLower();
		
		if(!exists($hash{"PrePhased"})){
			print "Step 4\n"; 
			createPanels();

			print "Step 5\n";	 
			phasingCheckWithShapeit();

			print "Step 6\n";
			plinkFlip();
		}else{
			my @prePhased=keys(%{$hash{"PrePhased"}});
			foreach $z (0..$#prePhased){
				$hash{"Phase"}{@prePhased[$z]}="";
			}
		}		
		
	}else{
		print "Step 3 (B)\n";
		findHigherAndLowerBed();
		if(!exists($hash{"PrePhased"})){
			print "Step 4 (B)\n"; 
			createPanelsBed();	
			
			print "Step 5 (B)\n";
			phasingCheckWithShapeitBed();

			print "Step 6 (B)\n"; 
			plinkFlipBed();
		}else{
			my @prePhased=keys(%{$hash{"PrePhased"}});
			foreach $z (0..$#prePhased){
				$hash{"Phase"}{@prePhased[$z]}="";
			}
		}
	}

	if(!exists($hash{"PrePhased"})){
		print "Step 7\n";
		shapeitCheckAfterFlip();
		
		print "Step 8\n";
		shapeitExclude();
		
		print "Step 9\n";
		phasingTarget();
	}else{
		my @prePhased=keys(%{$hash{"PrePhased"}});
		foreach $z (0..$#prePhased){
			$hash{"Phase"}{@prePhased[$z]}="";
		}
	}

	print "Step 9.5\n";
	checkPanelsBeforeImputation();
		
	print "Step 10\n"; 
	$imputation=1;
	$threadsImputation=8;
	if($dontImpute!=1){
		impute();
	}
}


sub checkPanelsBeforeImputation{
	my($i, $j, $k, $namePanel, $nameFile, $quantity);
	my(@keys, @keys2);
	
	undef %panels;
	
	
	@keys=keys(%{$hash{"Panels"}});
	
	foreach $i (0..$#keys){
		if(@keys[$i] ne "MergePanels"){
			if(!exists($panels{@keys[$i]})){
				if(!exists($hash{"Haplotypes"}{@keys[$i]})){
					$panels{@keys[$i]}="$output/Panel_@keys[$i].chr$chr";
				}else{
					$panels{@keys[$i]}="PreExisting";
				}
			}
		}else{	
			$quantity=$hash{"Panels"}{"MergePanels"}{"contador"};
			foreach $j (0..$quantity){
				@keys2=keys(%{$hash{"Panels"}{"MergePanels"}{$j}});
				$namePanel=""; $nameFile="";
				foreach $k (0..$#keys2){
					if($k == 0){
						$namePanel=$hash{"Panels"}{"MergePanels"}{$j}{$k};
						$nameFile=$hash{"Panels"}{"MergePanels"}{$j}{$k};
					}else{
						$namePanel=$namePanel."+".$hash{"Panels"}{"MergePanels"}{$j}{$k};
						$nameFile=$nameFile."_".$hash{"Panels"}{"MergePanels"}{$j}{$k};
					}
				}
				if(!exists($panels{$namePanel})){
					$panels{$namePanel}="$output/Panel_$nameFile.chr$chr";
				}
			}
		}
	}
	
	#print Dumper %panels;
	#<STDIN>;
	
}


sub getInfoOfPhase{
	my($string, $i, $j, $l, $k,$m, $soma, $nameOfFile, $higher);
	my(@vector, @panelsKeys, @file, @quantidade, @linha);

	
	@vector=keys(%{$hash{"Impute"}});
	@panelsKeys=keys(%panels);
        
	foreach $j (0..$#vector){
		@panelsKeys=keys(%panels);
		foreach $k (0..$#panelsKeys){
			if($panels{@panelsKeys[$k]} eq "PreExisting"){
				
				$nameOfFile="gwas.alignments_after_flip_Panel".@panelsKeys[$k].".chr$chr.log";
				print "Open -> $nameOfFile\n";
				open (IF,"$output/$nameOfFile"); #or die ("Error: $nameOfFile nao encontrado\n");
			}else{
				my @temp=split(/\+/, @panelsKeys[$k]);
				if($#temp<1){
					$nameOfFile="gwas.alignments_after_flip_Panel".@panelsKeys[$k].".chr$chr.log";
					print "Open -> $nameOfFile\n";
					open (IF, "$output/$nameOfFile"); #or die ("Error: $nameOfFile nao encontrado\n");
				}

			}
			@file=<IF>;
			foreach $m (0..$#file){
				#print substr(@file[$m],0,15)."\n";
				if(substr(@file[$m],0,15) eq "Reading SNPs in"){
					@linha=split(/\s+/, @file[$m+1]);
				}
			}
			$panels{"Included"}{@panelsKeys[$k]}=@linha[2];
		}
		foreach $k (0..$#panelsKeys){

			my @temp=split(/\+/, @panelsKeys[$k]);
			if($#temp>0){
				foreach $l (0..$#temp){
					@quantidade[$#quantidade+1]=$panels{"Included"}{@temp[$l]};
				}
				$higher=0;
				foreach $l (1..$#temp){
                                        if(@quantidade[$higher]<@quantidade[$l]){
						$higher=$l;
					}
                                }
				$panels{"Phase"}{@panelsKeys[$k]}=@temp[$higher];
			}else{
				$panels{"Phase"}{@panelsKeys[$k]}=@panelsKeys[$k];
			}

		}
		#print Dumper %panels; 
	}
}
#~ 
sub impute{
	my($string, $i, $j, $l, $k, $soma, $m, $largerPanel, $hap, $leg, $teste1, $teste2);
	my(@vector, @panelsKeys, @singlePanels);
	
	@singlePanels=keys(%{$hash{"Phase"}});
	
	@vector=keys(%{$hash{"Impute"}});
	if(exists($path{"Impute2"})){
		foreach $j (0..$#vector){
			$concluido=0;
			@panelsKeys=keys(%panels);
			
			foreach $teste1 (0..$#singlePanels){
				my @tempKeys=keys(%panels);
				foreach $teste2 (0..$#tempKeys){
					$panels{"Phase"}{@tempKeys[$teste2]}=@singlePanels[$teste1];
				}
				foreach $k (0..$#panelsKeys){
					if(@panelsKeys[$k] ne "Phase" and @panelsKeys[$k] ne "Included"){
						if($hash{"Chunk"} eq "" or $hash{"Chunk"} eq "0" or !exists($hash{"Chunk"})){
							if($panels{@panelsKeys[$k]} eq "PreExisting"){
								$string=$path{"Impute2"}." -use_prephased_g -m ";
								$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -h ".$hash{"Haplotypes"}{@panelsKeys[$k]}." -l 
".$hash{"Legend"}{@panelsKeys[$k]}." -known_haps_g ";
								$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps 
-allow_large_regions -Ne  20000 -int $lower $higher -o ";
								
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Completo.chr$chr.impute2";
								$string=~s /\*/$chr/gi;
								run($string);
							}else{
								my @temp=split(/\+/,@panelsKeys[$k]);
								if($#temp<2){
									if($#temp<1){
										$string=$path{"Impute2"}." -use_prephased_g -m ";
										$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -h ".$panels{@panelsKeys[$k]}.".hap -l 
".$panels{@panelsKeys[$k]}.".leg -known_haps_g ";
										$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps 
-allow_large_regions -Ne  20000 -int $lower $higher -o ";
										
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Completo.chr$chr.impute2";
										$string=~s /\*/$chr/gi;
										
										run($string);
									}else{
										$string=$path{"Impute2"}." -use_prephased_g -m ";
										$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -h ".$panels{@panelsKeys[$k]}.".hap -l 
".$panels{@panelsKeys[$k]}.".legend -known_haps_g ";
										$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps 
-allow_large_regions -Ne  20000 -int $lower $higher -o ";
										
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Completo.chr$chr.impute2";
										$string=~s /\*/$chr/gi;
										
										run($string);
									}
									
								}else{
									$largerPanel="";
									my @temp2=split("/", $panels{@panelsKeys[$k]});
									foreach $m(0..$#temp-1){
										$largerPanel=$largerPanel."_@temp[$m]";
									}
									$largerPanel="Panel$largerPanel";
									
									print "============================================================\n";
									print $panels{@temp[$#temp]}."\n";
									print $hash{"Haplotypes"}{@temp[$#temp]}."\n";
									if($panels{@temp[$#temp]} eq "PreExisting" or exists($hash{"Haplotypes"}{@temp[$#temp]})){
										$hap= $hash{"Haplotypes"}{@temp[$#temp]}." $output/".$largerPanel.".chr$chr.hap";
										$leg= $hash{"Legend"}{@temp[$#temp]}." $output/".$largerPanel.".chr$chr.legend";
									}
									
									$string=$path{"Impute2"}." -use_prephased_g -m ";
									$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -merge_ref_panels -h $hap -l $leg -known_haps_g ";
									$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps 
-allow_large_regions -Ne  20000 -int $lower $higher -o ";
									
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Completo.chr$chr.impute2";
									$string=~s /\*/$chr/gi;
									
									run($string);
								}
							}
						}else{
							if($panels{@panelsKeys[$k]} eq "PreExisting"){
								
								for($l=$lower; $l+$hash{"Chunk"}<=$higher; $l=$l+$hash{"Chunk"}){
									$soma=$l+$hash{"Chunk"};
									
									$string=$path{"Impute2"}." -use_prephased_g -m ";
									$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -h ".$hash{"Haplotypes"}{@panelsKeys[$k]}." -l 
".$hash{"Legend"}{@panelsKeys[$k]}." -known_haps_g ";
									$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps 
-allow_large_regions -Ne  20000 -int $l ".$soma." -o ";
									
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Int$l\-".$soma.".chr$chr.impute2";
									$string=~s /\*/$chr/gi;
									
									run($string);
								}
								$l=$l+$hash{"Chunk"};
								if($l-$hash{"Chunk"} <= $higher){
									$soma=$l-$hash{"Chunk"};
									
									$string=$path{"Impute2"}." -use_prephased_g -m ";
									$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -h ".$hash{"Haplotypes"}{@panelsKeys[$k]}." -l 
".$hash{"Legend"}{@panelsKeys[$k]}." -known_haps_g ";
									$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps 
-allow_large_regions -Ne  20000 -int ".$soma." $higher -o ";
									
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Int".$soma."\-$higher.chr$chr.impute2";
									$string=~s /\*/$chr/gi;
									
									run($string);
								}
								
							}else{
								my @temp=split(/\+/,@panelsKeys[$k]);
								if($#temp<2){
									if($#temp<1){
										for($l=$lower; $l+$hash{"Chunk"}<=$higher; $l=$l+$hash{"Chunk"}){
											$soma=$l+$hash{"Chunk"};
											
											$string=$path{"Impute2"}." -use_prephased_g -m ";
											$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -h ".$panels{@panelsKeys[$k]}.".hap -l 
".$panels{@panelsKeys[$k]}.".leg -known_haps_g ";
											
$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps -allow_large_regions -Ne  20000 -int $l ".$soma." -o ";
											
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Int$l\-".$soma.".chr$chr.impute2";
											$string=~s /\*/$chr/gi;
											
											run($string);
										}
										$l=$l+$hash{"Chunk"};
										if($l-$hash{"Chunk"} <= $higher){
											$soma=$l-$hash{"Chunk"};
											$string=$path{"Impute2"}." -use_prephased_g -m ";
											$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -h ".$panels{@panelsKeys[$k]}.".hap -l 
".$panels{@panelsKeys[$k]}.".leg -known_haps_g ";
											
$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps -allow_large_regions -Ne  20000 -int ".$soma." $higher -o ";
											
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Int".$soma."\-$higher.chr$chr.impute2";
											$string=~s /\*/$chr/gi;
											
											run($string);
										}
									}else{
										for($l=$lower; $l+$hash{"Chunk"}<=$higher; $l=$l+$hash{"Chunk"}){
												$soma=$l+$hash{"Chunk"};
												
												$string=$path{"Impute2"}." -use_prephased_g -m ";
												$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -h ".$panels{@panelsKeys[$k]}.".hap -l 
".$panels{@panelsKeys[$k]}.".legend -known_haps_g ";
												
$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps -allow_large_regions -Ne  20000 -int $l ".$soma." -o ";
												
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Int$l\-".$soma.".chr$chr.impute2";
												$string=~s /\*/$chr/gi;
												
												run($string);
											}
											$l=$l+$hash{"Chunk"};
											if($l-$hash{"Chunk"} <= $higher){
												$soma=$l-$hash{"Chunk"};
												$string=$path{"Impute2"}." -use_prephased_g -m ";
												$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -h ".$panels{@panelsKeys[$k]}.".hap -l 
".$panels{@panelsKeys[$k]}.".legend -known_haps_g ";
												
$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps -allow_large_regions -Ne  20000 -int ".$soma." $higher -o ";
												
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Int".$soma."\-$higher.chr$chr.impute2";
												$string=~s /\*/$chr/gi;
												
												run($string);
											}
										
									}
								}else{
									$largerPanel="";
									
									my @temp2=split("/", $panels{@panelsKeys[$k]});
									foreach $m(0..$#temp-1){
										$largerPanel=$largerPanel."_@temp[$m]";
									}
									$largerPanel="Panel$largerPanel";
									if($panels{@temp[$#temp]} eq "PreExisting" or exists($hash{"Haplotypes"}{@temp[$#temp]})){
										$hap= $hash{"Haplotypes"}{@temp[$#temp]}." $output/".$largerPanel.".chr$chr.hap";
										$leg= $hash{"Legend"}{@temp[$#temp]}." $output/".$largerPanel.".chr$chr.legend";
									}
									
								
									for($l=$lower; $l+$hash{"Chunk"}<=$higher; $l=$l+$hash{"Chunk"}){
										$soma=$l+$hash{"Chunk"};
										
										$string=$path{"Impute2"}." -use_prephased_g -m ";
										$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -merge_ref_panels -h $hap -l $leg -known_haps_g ";
										$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps 
-allow_large_regions -Ne  20000 -int $l ".$soma." -o ";
										
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Int$l\-".$soma.".chr$chr.impute2";
										$string=~s /\*/$chr/gi;
										
										run($string);
									}
									$l=$l+$hash{"Chunk"};
									if($l-$hash{"Chunk"} <= $higher){
										$soma=$l-$hash{"Chunk"};
										$string=$path{"Impute2"}." -use_prephased_g -m ";
										$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." -merge_ref_panels -h $hap -l $leg -known_haps_g ";
										$string=$string."$output/@vector[$j]_flipped_exclude_Panel".$panels{"Phase"}{@panelsKeys[$k]}.".chr$chr.haps 
-allow_large_regions -Ne  20000 -int ".$soma." $higher -o ";
										
$string=$string."$output/@vector[$j]_Panel@panelsKeys[$k]_Phase".$panels{"Phase"}{@panelsKeys[$k]}."_Int".$soma."\-$higher.chr$chr.impute2";
										$string=~s /\*/$chr/gi;
										
										run($string);
									}								
								}
							}
						}
					}
				}
			}
			$concluido = 1;
			run();
		}
	}else{
		die("Error: Impute2 not found\n");
	}



}

sub findHigherAndLowerBed{
	my($string, $i, $j, $file);
	my(@vector, @file, @temp);
	
	#Gunzip
	
	@vector=keys(%{$hash{"Impute"}});
	foreach $j (0..$#vector){
	

		$file=$hash{"Database"}{"@vector[$j]"}.".bim";
		$file=~ s/\*/$chr/gi;
		open (IF,$file ) or die("Error: $file not found\n");
		@file=<IF>;
		
		@file[0]=~ s/\n//gi;
		@file[0]=~ s/\r//gi;
		
		@temp=split(/\s+/,@file[0]);
		$lower=@temp[3];
		
		@file[$#file]=~ s/\n//gi;
		@file[$#file]=~ s/\r//gi;
		
		if(@file[$#file] eq ""){
		
			@temp=split(/\s+/,@file[$#file-1]);
		}else{
			@temp=split(/\s+/,@file[$#file]);
		}
		$higher=@temp[3];
	}
	if($hash{"Interval"} ne ""){
		@temp=split(/\s+/, $hash{"Interval"});
		$lower=@temp[0];
		$higher=@temp[1];
	}
	
}

sub findHigherAndLower{
	my($string, $i, $j, $file);
	my(@vector, @file, @temp);
	
	#Gunzip
	
	@vector=keys(%{$hash{"Impute"}});
	foreach $j (0..$#vector){
	

		$file=$hash{"Database"}{"@vector[$j]"}.".map";
		$file=~ s/\*/$chr/gi;
		open (IF,$file ) or die("Error: $file not found\n");
		@file=<IF>;
		
		@file[0]=~ s/\n//gi;
		@file[0]=~ s/\r//gi;
		
		@temp=split(/\s+/,@file[0]);
		$lower=@temp[3];
		
		@file[$#file]=~ s/\n//gi;
		@file[$#file]=~ s/\r//gi;
		
		if(@file[$#file] eq ""){
			@temp=split(/\s+/,@file[$#file-1]);
		}else{
			@temp=split(/\s+/,@file[$#file]);
		}
		$higher=@temp[3];
	}
	if($hash{"Interval"} ne ""){
		@temp=split(/\s+/, $hash{"Interval"});
		$lower=@temp[0];
		$higher=@temp[1];
	}
	
}

sub phasingTarget{
	my($string, $i, $j, $k);
	my(@vector, @panelsKeys);


	@panelsKeys=keys(%{$hash{"Phase"}});
	#print $#panelsKeys."\n";
	#print Dumper %hash;
	if(exists($hash{"OnlyPhase"}) && $#panelsKeys == -1){
		if($bed!= 1){
			phasingTargetWithoutReference();
		}else{
			phasingTargetWithoutReferenceBed();
		}
	}else{
		@vector=keys(%{$hash{"Impute"}});
		if(exists($path{"Shapeit"})){
			foreach $j (0..$#vector){
				@panelsKeys=keys(%{$hash{"Phase"}});
				foreach $k (0..$#panelsKeys){
					
					if($panels{@panelsKeys[$k]} eq "PreExisting"){
					
						$string=$path{"Shapeit"}." -B $output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr --thread $threads -M ";
						$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --input-ref ".$hash{"Haplotypes"}{@panelsKeys[$k]}." ".$hash{"Legend"}{@panelsKeys[$k]}." 
".$hash{"Sample"}{@panelsKeys[$k]};
						$string=$string." --exclude-snp $output/gwas.alignments_after_flip_Panel@panelsKeys[$k].chr$chr.snp.strand.exclude -O 
$output/@vector[$j]_flipped_exclude_Panel@panelsKeys[$k].chr$chr.haps $output/@vector[$j]_flipped_exclude_Panel@panelsKeys[$k].chr$chr.sample";
						$string=~s /\*/$chr/gi;
					
						if($seed ne ""){
							$string=$string." --seed $seed";
						}
						if($states ne ""){
							$string=$string." --states $states";
						}
						
						run($string);
						addExclude("$output/gwas.alignments_after_flip_Panel@panelsKeys[$k].*");
					}else{
						my @temp=split(/\+/, @panelsKeys[$k]);
						if($#temp<1){
			
							$string=$path{"Shapeit"}." -B $output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr --thread $threads -M ";
							$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --input-ref ".$panels{@panelsKeys[$k]}.".hap ".$panels{@panelsKeys[$k]}.".leg 
".$panels{@panelsKeys[$k]}.".sam";
							$string=$string." --exclude-snp $output/gwas.alignments_after_flip_Panel@panelsKeys[$k].chr$chr.snp.strand.exclude -O 
$output/@vector[$j]_flipped_exclude_Panel@panelsKeys[$k].chr$chr.haps $output/@vector[$j]_flipped_exclude_Panel@panelsKeys[$k].chr$chr.sample";
							$string=~s /\*/$chr/gi;
					
							if($seed ne ""){
								$string=$string." --seed $seed";
							}
							if($states ne ""){
								$string=$string." --states $states";
							}
						
						
							run($string);
							addExclude("$output/gwas.alignments_after_flip_Panel@panelsKeys[$k].*");
						}
					}
				}
			}
		
		}else{
			die("Error: Plink not found\n");
		}
	}




}

sub phasingTargetWithoutReference{
	my($string, $i, $j, $k);
	my(@vector, @panelsKeys);

	@vector=keys(%{$hash{"Impute"}});
	if(exists($path{"Shapeit"})){
		foreach $j (0..$#vector){
			
			$string=$path{"Shapeit"}." --input-ped ".$hash{"Database"}{@vector[$i]}.".ped ".$hash{"Database"}{@vector[$i]}.".map -M ";
			$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --output-max $output/".@vector[$i]."_PhasedWithoutReference.chr$chr.haps 
$output/".@vector[$i]."_PhasedWithoutReference.chr$chr.sample --thread $threads";
			$string=~s /\*/$chr/gi;
				
			run($string);
		}
	
	}else{
		die("Error: Plink not found\n");
	}
}


sub phasingTargetWithoutReferenceBed{
	my($string, $i, $j, $k);
	my(@vector, @panelsKeys);

	@vector=keys(%{$hash{"Impute"}});
	if(exists($path{"Shapeit"})){
		foreach $j (0..$#vector){
			
			$string=$path{"Shapeit"}." --input-bed ".$hash{"Database"}{@vector[$i]}.".bed ".$hash{"Database"}{@vector[$i]}.".bim ".$hash{"Database"}{@vector[$i]}.".fam -M ";
			$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --output-max $output/".@vector[$i]."_PhasedWithoutReference.chr$chr.haps 
$output/".@vector[$i]."_PhasedWithoutReference.chr$chr.sample --thread $threads";
			$string=~s /\*/$chr/gi;
				
			run($string);
		}
	
	}else{
		die("Erro: Plink not find\n");
	}
}


sub createPanelsBed{
	my ($temporary,$i, $j, $k, $string, $quantity, $leg, $hap, $name, $largerPanel, $preExisting, $namePanel);
	my (@vector, @keys, @return);
	
	while ($temporary = each(%{$hash{"Create"}})){
		@vector[$#vector+1]= $temporary;
	}
	
	foreach $i (0..$#vector){
		if(exists($hash{"Create"}{"MergePanels"})){
			if(@vector[$#vector] ne "MergePanels"){
				foreach $j (0..$#vector){
					if(@vector[$j] eq "MergePanels"){
						@vector[$j]=@vector[$#vector];
					}
				}
				@vector[$#vector]="MergePanels";
			}
		}
		if(@vector[$i] ne "MergePanels"){
		
			$string=$path{"Shapeit"}." --input-bed ".$hash{"Database"}{@vector[$i]}.".bed ".$hash{"Database"}{@vector[$i]}.".bim ".$hash{"Database"}{@vector[$i]}.".fam -M ";
			$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --output-max $output/Panel_".@vector[$i].".chr$chr.haps $output/Panel_".@vector[$i].".chr$chr.sample --thread 
$threads";
			$string=~s /\*/$chr/gi;
				
			run($string);
			addExclude("$output/Panel_".@vector[$i].".chr$chr.haps");
			addExclude("$output/Panel_".@vector[$i].".chr$chr.sample");
			
				
			$string=$path{"Shapeit"}." -convert --input-haps $output/Panel_".@vector[$i].".chr$chr --output-ref $output/Panel_".@vector[$i].".chr$chr.hap 
$output/Panel_".@vector[$i].".chr$chr.leg $output/Panel_".@vector[$i].".chr$chr.sam";
			$panels{@vector[$i]}="$output/Panel_".@vector[$i].".chr$chr";
				
			run($string);
			
		}else{
			$quantity=$hash{"Create"}{"MergePanels"}{"contador"};
			foreach $j (0..$quantity){
				@keys=();
				$name="";
				while ($temporary = each(%{$hash{"Create"}{"MergePanels"}{$j}})){
					@keys[$#keys+1]= $temporary;
				}
	
				$string=$path{"Impute2"}." -merge_ref_panels -m ".$hash{"GeneticMap"}{"GeneticMap"};
				$hap="";$leg="";
				$namePanel="";
				#Merge two panels
				if($#keys == 1){
					foreach $k (0..$#keys){
						if($k!=$#keys){
							$namePanel=$namePanel.$hash{"Create"}{"MergePanels"}{$j}{$k}."+";
						}else{
							$namePanel=$namePanel.$hash{"Create"}{"MergePanels"}{$j}{$k};
						}
						$preExisting=verifiesThatThePanelExists("Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.hap", 
$hash{"Create"}{"MergePanels"}{$j}{$k});
						if($preExisting==0){
							$hap=$hap." $output/Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.hap";
							$leg=$leg." $output/Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.leg";
							$name=$name."_".$hash{"Create"}{"MergePanels"}{$j}{$k};
						}else{
							$hap=$hash{"Haplotypes"}{$hash{"Create"}{"MergePanels"}{$j}{$k}}." ".$hap;
							$leg=$hash{"Legend"}{$hash{"Create"}{"MergePanels"}{$j}{$k}}." ".$leg;
							$name=$name."_".$hash{"Create"}{"MergePanels"}{$j}{$k};
						}
					}
					$string=$string." -h $hap -l $leg -merge_ref_panels_output_ref $output/Panel$name.chr$chr -allow_large_regions -int $lower $higher";
					$panels{$namePanel}="$output/Panel$name.chr$chr";
					$string=~s /\*/$chr/gi;
					run($string);
					
				}else{
					#Merge two panels
					$largerPanel="";
					foreach $k (0..$#keys-1){
						$namePanel=$namePanel.$hash{"Create"}{"MergePanels"}{$j}{$k}."+";
						$largerPanel=$largerPanel."_".$hash{"Create"}{"MergePanels"}{$j}{$k};
						
					}
					$name=$largerPanel;
					$largerPanel="Panel$largerPanel";
					$preExisting=verifiesThatThePanelExists($largerPanel.".chr$chr.hap",$hash{"Create"}{"MergePanels"}{$j}{$k});
					$hap=" $output/Panel$name.chr$chr.hap";
					$leg=" $output/Panel$name.chr$chr.legend";
					
					$k=$#keys;
					$namePanel=$namePanel.$hash{"Create"}{"MergePanels"}{$j}{$k};
					$preExisting=verifiesThatThePanelExists("Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.hap",$hash{"Create"}{"MergePanels"}{$j}{$k});
					if($preExisting==0){
						$hap=$hap." $output/Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.hap";
						$leg=$leg." $output/Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.leg";
						$name=$name."_".$hash{"Create"}{"MergePanels"}{$j}{$k};
					}else{
						$hap=$hash{"Haplotypes"}{$hash{"Create"}{"MergePanels"}{$j}{$k}}." ".$hap;
						$leg=$hash{"Legend"}{$hash{"Create"}{"MergePanels"}{$j}{$k}}." ".$leg;
						$name=$name."_".$hash{"Create"}{"MergePanels"}{$j}{$k};
					}
					$string=$string." -h $hap -l $leg -merge_ref_panels_output_ref $output/Panel$name.chr$chr -allow_large_regions -int $lower $higher";
					$panels{$namePanel}="$output/Panel$name.chr$chr";
					$string=~s /\*/$chr/gi;
					run($string);
				}
			}
		}
	}
	my @keys=keys(%{$hash{"Panels"}});
	my @keys2;
	my($namePanel, $nameFile);
	
	foreach $i (0..$#keys){
		if(@keys[$i] ne "MergePanels"){
			if(!exists($panels{@keys[$i]})){
				if(!exists($hash{"Haplotypes"}{@keys[$i]})){
					$panels{@keys[$i]}="$output/Panel_@keys[$i].chr$chr";
				}else{
					$panels{@keys[$i]}="PreExisting";
				}
			}
		}else{	
			$quantity=$hash{"Panels"}{"MergePanels"}{"contador"};
			foreach $j (0..$quantity){
				@keys2=keys(%{$hash{"Panels"}{"MergePanels"}{$j}});
				$namePanel=""; $nameFile="";
				foreach $k (0..$#keys2){
					if($k == 0){
						$namePanel=$hash{"Panels"}{"MergePanels"}{$j}{$k};
						$nameFile=$hash{"Panels"}{"MergePanels"}{$j}{$k};
					}else{
						$namePanel=$namePanel."+".$hash{"Panels"}{"MergePanels"}{$j}{$k};
						$nameFile=$nameFile."_".$hash{"Panels"}{"MergePanels"}{$j}{$k};
					}
				}
				if(!exists($panels{$namePanel})){
					$panels{$namePanel}="$output/Panel_$nameFile.chr$chr";
				}				
			}
		}
	}
	
	if(exists($hash{"OnlyPhase"})){
		
		my @keys=keys(%{$hash{"Phase"}});
		foreach $i (0..$#keys){
			if(@keys[$i] ne "MergePanels"){
				if(!exists($panels{@keys[$i]})){
					if(!exists($hash{"Haplotypes"}{@keys[$i]})){
						$panels{@keys[$i]}="$output/Panel_@keys[$i].chr$chr";
					}else{
						$panels{@keys[$i]}="PreExisting";
					}
				}
			}else{	
				$quantity=$hash{"Panels"}{"MergePanels"}{"contador"};
				foreach $j (0..$quantity){
					@keys2=keys(%{$hash{"Panels"}{"MergePanels"}{$j}});
					$namePanel=""; $nameFile="";
					foreach $k (0..$#keys2){
						if($k == 0){
							$namePanel=$hash{"Panels"}{"MergePanels"}{$j}{$k};
							$nameFile=$hash{"Panels"}{"MergePanels"}{$j}{$k};
						}else{
							$namePanel=$namePanel."+".$hash{"Panels"}{"MergePanels"}{$j}{$k};
							$nameFile=$nameFile."_".$hash{"Panels"}{"MergePanels"}{$j}{$k};
						}
					}
					if(!exists($panels{$namePanel})){
						$panels{$namePanel}="$output/Panel_$nameFile.chr$chr";
					}				
				}
			}
		}
	}
}

sub createPanels{
	my ($temporary,$i, $j, $k, $string, $quantity, $leg, $hap, $name, $largerPanel, $preExisting, $namePanel);
	my (@vector, @keys, @return);
	
	while ($temporary = each(%{$hash{"Create"}})){
		@vector[$#vector+1]= $temporary;
	}
	
	foreach $i (0..$#vector){
		if(exists($hash{"Create"}{"MergePanels"})){
			if(@vector[$#vector] ne "MergePanels"){
				foreach $j (0..$#vector){
					if(@vector[$j] eq "MergePanels"){
						@vector[$j]=@vector[$#vector];
					}
				}
				@vector[$#vector]="MergePanels";
			}
		}
		if(@vector[$i] ne "MergePanels"){
		
			$string=$path{"Shapeit"}." --input-ped ".$hash{"Database"}{@vector[$i]}.".ped ".$hash{"Database"}{@vector[$i]}.".map -M ";
			$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --output-max $output/Panel_".@vector[$i].".chr$chr.haps $output/Panel_".@vector[$i].".chr$chr.sample --thread 
$threads";
			$string=~s /\*/$chr/gi;
				
			run($string);
			addExclude("$output/Panel_".@vector[$i].".chr$chr.haps");
			addExclude("$output/Panel_".@vector[$i].".chr$chr.sample");
			
				
			$string=$path{"Shapeit"}." -convert --input-haps $output/Panel_".@vector[$i].".chr$chr --output-ref $output/Panel_".@vector[$i].".chr$chr.hap 
$output/Panel_".@vector[$i].".chr$chr.leg $output/Panel_".@vector[$i].".chr$chr.sam";
			$panels{@vector[$i]}="$output/Panel_".@vector[$i].".chr$chr";
				
			run($string);
			
		}else{
			$quantity=$hash{"Create"}{"MergePanels"}{"contador"};
			foreach $j (0..$quantity){
				@keys=();
				$name="";

				while ($temporary = each(%{$hash{"Create"}{"MergePanels"}{$j}})){
					@keys[$#keys+1]= $temporary;
				}

				$string=$path{"Impute2"}." -merge_ref_panels -m ".$hash{"GeneticMap"}{"GeneticMap"};
				$hap="";$leg="";
				$namePanel="";
				#Merge two panels
				if($#keys == 1){
					foreach $k (0..$#keys){
						if($k!=$#keys){
							$namePanel=$namePanel.$hash{"Create"}{"MergePanels"}{$j}{$k}."+";
						}else{
							$namePanel=$namePanel.$hash{"Create"}{"MergePanels"}{$j}{$k};
						}
						$preExisting=verifiesThatThePanelExists("Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.hap", 
$hash{"Create"}{"MergePanels"}{$j}{$k});
						if($preExisting==0){
							$hap=$hap." $output/Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.hap";
							$leg=$leg." $output/Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.leg";
							$name=$name."_".$hash{"Create"}{"MergePanels"}{$j}{$k};
						}else{
							$hap=$hash{"Haplotypes"}{$hash{"Create"}{"MergePanels"}{$j}{$k}}." ".$hap;
							$leg=$hash{"Legend"}{$hash{"Create"}{"MergePanels"}{$j}{$k}}." ".$leg;
							$name=$name."_".$hash{"Create"}{"MergePanels"}{$j}{$k};
						}
					}
					$string=$string." -h $hap -l $leg -merge_ref_panels_output_ref $output/Panel$name.chr$chr -allow_large_regions -int $lower $higher";
					$panels{$namePanel}="$output/Panel$name.chr$chr";
					$string=~s /\*/$chr/gi;
					run($string);
				}else{
					#Merge two panels
					$largerPanel="";
					foreach $k (0..$#keys-1){
						$namePanel=$namePanel.$hash{"Create"}{"MergePanels"}{$j}{$k}."+";
						$largerPanel=$largerPanel."_".$hash{"Create"}{"MergePanels"}{$j}{$k};
						
					}
					$name=$largerPanel;
					$largerPanel="Panel$largerPanel";
					$preExisting=verifiesThatThePanelExists($largerPanel.".chr$chr.hap",$hash{"Create"}{"MergePanels"}{$j}{$k});
					$hap=" $output/Panel$name.chr$chr.hap";
					$leg=" $output/Panel$name.chr$chr.legend";
					
					$k=$#keys;
					$namePanel=$namePanel.$hash{"Create"}{"MergePanels"}{$j}{$k};
					$preExisting=verifiesThatThePanelExists("Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.hap",$hash{"Create"}{"MergePanels"}{$j}{$k});
					if($preExisting==0){
						$hap=$hap." $output/Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.hap";
						$leg=$leg." $output/Panel_".$hash{"Create"}{"MergePanels"}{$j}{$k}.".chr$chr.leg";
						$name=$name."_".$hash{"Create"}{"MergePanels"}{$j}{$k};
					}else{
						$hap=$hash{"Haplotypes"}{$hash{"Create"}{"MergePanels"}{$j}{$k}}." ".$hap;
						$leg=$hash{"Legend"}{$hash{"Create"}{"MergePanels"}{$j}{$k}}." ".$leg;
						$name=$name."_".$hash{"Create"}{"MergePanels"}{$j}{$k};
					}
					$string=$string." -h $hap -l $leg -merge_ref_panels_output_ref $output/Panel$name.chr$chr -allow_large_regions -int $lower $higher";
					$panels{$namePanel}="$output/Panel$name.chr$chr";
					$string=~s /\*/$chr/gi;
					run($string);
				}
			}
		}
	}
	my @keys=keys(%{$hash{"Panels"}});
	my @keys2;
	my($namePanel, $nameFile);
	
	foreach $i (0..$#keys){
		if(@keys[$i] ne "MergePanels"){
			if(!exists($panels{@keys[$i]})){
				if(!exists($hash{"Haplotypes"}{@keys[$i]})){
					$panels{@keys[$i]}="$output/Panel_@keys[$i].chr$chr";
				}else{
					$panels{@keys[$i]}="PreExisting";
				}
			}
		}else{	
			$quantity=$hash{"Panels"}{"MergePanels"}{"contador"};
			foreach $j (0..$quantity){
				@keys2=keys(%{$hash{"Panels"}{"MergePanels"}{$j}});
				$namePanel=""; $nameFile="";
				foreach $k (0..$#keys2){
					if($k == 0){
						$namePanel=$hash{"Panels"}{"MergePanels"}{$j}{$k};
						$nameFile=$hash{"Panels"}{"MergePanels"}{$j}{$k};
					}else{
						$namePanel=$namePanel."+".$hash{"Panels"}{"MergePanels"}{$j}{$k};
						$nameFile=$nameFile."_".$hash{"Panels"}{"MergePanels"}{$j}{$k};
					}
				}
				if(!exists($panels{$namePanel})){
					$panels{$namePanel}="$output/Panel_$nameFile.chr$chr";
				}				
			}
		}
	}
	
	#Modificação para a GRANDE PHASE
	if(exists($hash{"OnlyPhase"})){
		
		my @keys=keys(%{$hash{"Phase"}});
		foreach $i (0..$#keys){
			if(@keys[$i] ne "MergePanels"){
				if(!exists($panels{@keys[$i]})){
					if(!exists($hash{"Haplotypes"}{@keys[$i]})){
						$panels{@keys[$i]}="$output/Panel_@keys[$i].chr$chr";
					}else{
						$panels{@keys[$i]}="PreExisting";
					}
				}
			}else{	
				$quantity=$hash{"Panels"}{"MergePanels"}{"contador"};
				foreach $j (0..$quantity){
					@keys2=keys(%{$hash{"Panels"}{"MergePanels"}{$j}});
					$namePanel=""; $nameFile="";
					foreach $k (0..$#keys2){
						if($k == 0){
							$namePanel=$hash{"Panels"}{"MergePanels"}{$j}{$k};
							$nameFile=$hash{"Panels"}{"MergePanels"}{$j}{$k};
						}else{
							$namePanel=$namePanel."+".$hash{"Panels"}{"MergePanels"}{$j}{$k};
							$nameFile=$nameFile."_".$hash{"Panels"}{"MergePanels"}{$j}{$k};
						}
					}
					if(!exists($panels{$namePanel})){
						$panels{$namePanel}="$output/Panel_$nameFile.chr$chr";
					}				
				}
			}
		}
	}
}


sub verifiesThatThePanelExists{
	my($i, $searched, $preExisting);
	my (@list);
	
	$searched=@_[0];
	$preExisting=@_[1];
	#print "$searched ou $preExisting\n";
	print "Looking for panel ' $searched ' to merge ";
	
	opendir(directory, "$output");
	@list = readdir(directory);
	closedir(directory);
	if(exists ($hash{"Haplotypes"}{"$preExisting"})){
		$panels{$preExisting}="PreExisting";
		print "........... Ok (This panel alredy exists)\n";
		
		return 1;
	}
	 
	foreach $i (0..$#list){
		#print "$searched eq @list[$i]\n";
		if($searched eq @list[$i]){
			print "........... Ok\n";
			
			return 0;
		}
	}
	print "........... ERRO\nErro: Panel '$searched' not found\n";
	die("\n");

}

sub shapeitExclude{
	my($string, $i, $j, $k);
	my(@vector, @panelsKeys);

	@vector=keys(%{$hash{"Impute"}});
	if(exists($path{"Shapeit"})){
		foreach $j (0..$#vector){
			@panelsKeys=keys(%{$hash{"Phase"}});
			foreach $k (0..$#panelsKeys){
				
				if($panels{@panelsKeys[$k]} eq "PreExisting"){
				
					$string=$path{"Shapeit"}." -check -B $output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr -M ";
					$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --input-ref ".$hash{"Haplotypes"}{@panelsKeys[$k]}." ".$hash{"Legend"}{@panelsKeys[$k]}." 
".$hash{"Sample"}{@panelsKeys[$k]};
					$string=$string." --exclude-snp $output/gwas.alignments_after_flip_Panel@panelsKeys[$k].chr$chr.snp.strand.exclude --output-log 
$output/gwas.alignments_after_flipExclude_Panel@panelsKeys[$k].chr$chr";
					$string=~s /\*/$chr/gi;
				
					
					run($string);
					addExclude("$output/gwas.alignments_after_flip_Panel@panelsKeys[$k].chr$chr.*");
				}else{
					my @temp=split(/\+/, @panelsKeys[$k]);
                                        if($#temp<1){

						$string=$path{"Shapeit"}." -check -B $output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr -M ";
						$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --input-ref ".$panels{@panelsKeys[$k]}.".hap ".$panels{@panelsKeys[$k]}.".leg 
".$panels{@panelsKeys[$k]}.".sam";
						$string=$string." --exclude-snp $output/gwas.alignments_after_flip_Panel@panelsKeys[$k].chr$chr.snp.strand.exclude --output-log 
$output/gwas.alignments_after_flipExclude_Panel@panelsKeys[$k].chr$chr";
						$string=~s /\*/$chr/gi;
				
					
						run($string);
						addExclude("$output/gwas.alignments_after_flip_Panel@panelsKeys[$k].chr$chr.*");
					}
				}
			}
		}
	
	}else{
		die("Error: Plink not found\n");
	}

}

sub shapeitCheckAfterFlip{
	my($string, $i, $j, $k);
	my(@vector, @panelsKeys);

	@vector=keys(%{$hash{"Impute"}});
	
	if(exists($path{"Shapeit"})){
		foreach $j (0..$#vector){
			@panelsKeys=keys(%{$hash{"Phase"}});
			foreach $k (0..$#panelsKeys){
				
				if($panels{@panelsKeys[$k]} eq "PreExisting"){
				
					$string=$path{"Shapeit"}." -check -B $output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr -M ";
					$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --input-ref ".$hash{"Haplotypes"}{@panelsKeys[$k]}." ".$hash{"Legend"}{@panelsKeys[$k]}." 
".$hash{"Sample"}{@panelsKeys[$k]};
					$string=$string." --output-log $output/gwas.alignments_after_flip_Panel@panelsKeys[$k].chr$chr";
					$string=~s /\*/$chr/gi;
				
					
					run($string);
					addExclude("$output/gwas.alignments_after_flip.*");
				}else{
					my @temp=split(/\+/, @panelsKeys[$k]);
					if($#temp<1){		
						$string=$path{"Shapeit"}." -check -B $output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr -M ";
						$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --input-ref ".$panels{@panelsKeys[$k]}.".hap ".$panels{@panelsKeys[$k]}.".leg 
".$panels{@panelsKeys[$k]}.".sam";
						$string=$string." --output-log $output/gwas.alignments_after_flip_Panel@panelsKeys[$k].chr$chr";
						$string=~s /\*/$chr/gi;
				
					
						run($string);
						addExclude("$output/gwas.alignments_after_flip_Panel@panelsKeys[$k].chr$chr.*");
					}
				}
			}
		}
	
	}else{
		die("Error: Plink not found\n");
	}
}

sub plinkFlip{
	my($string, $i, $j, $k);
	my(@vector, @panelsKeys);

	@vector=keys(%{$hash{"Impute"}});
	if(exists($path{"Plink"})){
	
		foreach $j (0..$#vector){
			@panelsKeys=keys(%{$hash{"Phase"}});
			foreach $k (0..$#panelsKeys){
				my @temp = split(/\+/, @panelsKeys[$k]);
				if($#temp<1){
					$string=$path{"Plink"}." --file $output/@vector[$j].chr$chr --flip $output/case1_Panel@panelsKeys[$k].chr$chr.txt --make-bed --out 
$output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr";
				
					run($string);
				
					addExclude("$output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr.bed");
					addExclude("$output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr.bim");
					addExclude("$output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr.fam");
				}
			}
		}
	
	}
	
}

sub plinkFlipBed{
	my($string, $i, $j, $k);
	my(@vector, @panelsKeys);

	@vector=keys(%{$hash{"Impute"}});
	if(exists($path{"Plink"})){
	
		foreach $j (0..$#vector){
			@panelsKeys=keys(%{$hash{"Phase"}});
			foreach $k (0..$#panelsKeys){
				my @temp = split(/\+/, @panelsKeys[$k]);
				if($#temp<1){
					$string=$path{"Plink"}." --bfile $output/@vector[$j].chr$chr --flip $output/case1_Panel@panelsKeys[$k].chr$chr.txt --make-bed --out 
$output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr";
				
					run($string);
				
					addExclude("$output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr.bed");
					addExclude("$output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr.bim");
					addExclude("$output/@vector[$j]_flipped_Panel@panelsKeys[$k].chr$chr.fam");
				}
			}
		}
	
	}
}

sub phasingCheckWithShapeit{
	my($string, $i, $j, $k, $file);
	my(@vector, @file, @temp, @panelsKeys);
	
	
	@vector=keys(%{$hash{"Impute"}});
	foreach $j (0..$#vector){
		$string="cp ".$hash{"Database"}{"@vector[$j]"}.".ped $output/@vector[$j].chr$chr.ped";
		$string=~s /\*/$chr/gi;
		run($string);
		addExclude("$output/@vector[$j].ped");
				
		$string="cp ".$hash{"Database"}{"@vector[$j]"}.".map $output/@vector[$j].chr$chr.map";
		$string=~s /\*/$chr/gi;
		run($string);
		addExclude("$output/@vector[$j].map");
	}

	#Plink
	if(exists($path{"Plink"})){
		foreach $j (0..$#vector){
			$string=$path{"Plink"}." --file $output/@vector[$j].chr$chr --make-bed --out $output/@vector[$j].chr$chr";
			
			run($string);
			
			addExclude("$output/@vector[$j].bed");
			addExclude("$output/@vector[$j].bim");
			addExclude("$output/@vector[$j].fam");
		}
	
	}else{
		die("Error:PLINK not found\n");
	}
	
	#Shapeit Check
	
	@panelsKeys=keys(%{$hash{"Phase"}});
	if(exists($path{"Shapeit"})){
		foreach $j (0..$#vector){
			foreach $k (0..$#panelsKeys){
				if($panels{@panelsKeys[$k]} eq "PreExisting"){
					$string=$path{"Shapeit"}." -check -B $output/@vector[$j].chr$chr -M ";
					$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --input-ref ".$hash{"Haplotypes"}{@panelsKeys[$k]}." ".$hash{"Legend"}{@panelsKeys[$k]}." 
".$hash{"Sample"}{@panelsKeys[$k]};
					$string=$string." --output-log $output/gwas.alignments_Panel@panelsKeys[$k].chr$chr";
					$string=~s /\*/$chr/gi;
                    run($string);
                    addExclude("$output/gwas.alignments_Panel@panelsKeys[$k].chr$chr.*");

				}else{	
					my @temp=split(/\+/,@panelsKeys[$k]);
					if($#temp<1){
							print "@panelsKeys[$k]\n";
							$string=$path{"Shapeit"}." -check -B $output/@vector[$j].chr$chr -M ";
							$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --input-ref ".$panels{@panelsKeys[$k]}.".hap ".$panels{@panelsKeys[$k]}.".leg 
".$panels{@panelsKeys[$k]}.".sam";
							$string=$string." --output-log $output/gwas.alignments_Panel@panelsKeys[$k].chr$chr";
							$string=~s /\*/$chr/gi;
					
				
				
							run($string);
							addExclude("$output/gwas.alignments_Panel@panelsKeys[$k].chr$chr.*");
					}
				}
			}	
		}
	
	}else{
		die("Erro: Plink not found\n");
	}
	foreach $k (0..$#panelsKeys){
		my @temp=split(/\+/,@panelsKeys[$k]);
		if($#temp<1){

			$string="awk '{if(\$1 == \"Strand\" && \$2 == \"Strand\"){print \$4 }}' $output/gwas.alignments_Panel@panelsKeys[$k].chr$chr.snp.strand | sort -u > 
$output/case1_Panel@panelsKeys[$k].chr$chr.txt";
		
			run($string);
			addExclude("$output/case1_Panel@panelsKeys[$k].txt");
		}
	}
}


sub phasingCheckWithShapeitBed{
	my($string, $i, $j, $k, $file);
	my(@vector, @file, @temp, @panelsKeys);
	
	#Gunzip
	
	@vector=keys(%{$hash{"Impute"}});
	foreach $j (0..$#vector){
		$string="cp ".$hash{"Database"}{"@vector[$j]"}.".bed $output/@vector[$j].chr$chr.bed";
		$string=~s /\*/$chr/gi;
		run($string);
		addExclude("$output/@vector[$j].bed");
		
		$string="cp ".$hash{"Database"}{"@vector[$j]"}.".bim $output/@vector[$j].chr$chr.bim";
		$string=~s /\*/$chr/gi;
		run($string);
		addExclude("$output/@vector[$j].bim");
				
		$string="cp ".$hash{"Database"}{"@vector[$j]"}.".fam $output/@vector[$j].chr$chr.fam";
		$string=~s /\*/$chr/gi;
		run($string);
		addExclude("$output/@vector[$j].fam");
	}

	#Plink
	if(exists($path{"Plink"})){
		foreach $j (0..$#vector){
			$string=$path{"Plink"}." --bfile $output/@vector[$j].chr$chr --make-bed --out $output/@vector[$j].chr$chr";
			
			run($string);
			
			addExclude("$output/@vector[$j].bed");
			addExclude("$output/@vector[$j].bim");
			addExclude("$output/@vector[$j].fam");
		}
	
	}else{
		die("Error: Plink not found\n");
	}
	
	#Shapeit Check
	@panelsKeys=keys(%{$hash{"Phase"}});
	if(exists($path{"Shapeit"})){
		foreach $j (0..$#vector){
			foreach $k (0..$#panelsKeys){
				if($panels{@panelsKeys[$k]} eq "PreExisting"){
					$string=$path{"Shapeit"}." -check -B $output/@vector[$j].chr$chr -M ";
					$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --input-ref ".$hash{"Haplotypes"}{@panelsKeys[$k]}." ".$hash{"Legend"}{@panelsKeys[$k]}." 
".$hash{"Sample"}{@panelsKeys[$k]};
					$string=$string." --output-log $output/gwas.alignments_Panel@panelsKeys[$k].chr$chr";
					$string=~s /\*/$chr/gi;
                    run($string);
                    addExclude("$output/gwas.alignments_Panel@panelsKeys[$k].chr$chr.*");

				}else{	
					my @temp=split(/\+/,@panelsKeys[$k]);
					if($#temp<1){
							print "@panelsKeys[$k]\n";
							$string=$path{"Shapeit"}." -check -B $output/@vector[$j].chr$chr -M ";
							$string=$string.$hash{"GeneticMap"}{"GeneticMap"}." --input-ref ".$panels{@panelsKeys[$k]}.".hap ".$panels{@panelsKeys[$k]}.".leg 
".$panels{@panelsKeys[$k]}.".sam";
							$string=$string." --output-log $output/gwas.alignments_Panel@panelsKeys[$k].chr$chr";
							$string=~s /\*/$chr/gi;
					
				
				
							run($string);
							addExclude("$output/gwas.alignments_Panel@panelsKeys[$k].chr$chr.*");
					}
				}
			}	
		}
	
	}else{
		die("Error: Plink not found\n");
	}
	foreach $k (0..$#panelsKeys){
		my @temp=split(/\+/,@panelsKeys[$k]);
		if($#temp<1){

			$string="awk '{if(\$1 == \"Strand\" && \$2 == \"Strand\"){print \$4 }}' $output/gwas.alignments_Panel@panelsKeys[$k].chr$chr.snp.strand | sort -u > 
$output/case1_Panel@panelsKeys[$k].chr$chr.txt";
		
			run($string);
			addExclude("$output/case1_Panel@panelsKeys[$k].txt");
		}
	}
}

sub readScriptsFile{
	my ($i, $nameProgram);
	my (@file);
	
	open (IF, $programsPath) or die ("Erro: $programsPath não encontrado\n");
	@file=<IF>;
	
	foreach $i (0..$#file){
		@file[$i]=~ s/\n//gi;
		@file[$i]=~ s/\r//gi;
	
		if(substr(@file[$i],0,1) eq "#"){
			$nameProgram=@file[$i];
			$nameProgram=~ s/#//gi;
		}else{
			$path{$nameProgram}=@file[$i];
			$nameProgram="";
		}
	}
	#print Dumper %path;
}


sub readInputFile{
	my($i, $j, $count, $activity, $name);
	my(@file, @temp, @temp2, @keys);
	
	run("mkdir $output");
	
	open (IF, $input) or die ("Error: $input not find\n");
	@file=<IF>;
	
	foreach $i (0..$#file){
		@file[$i]=~ s/\n//gi;
		@file[$i]=~ s/\r//gi;
		if(substr(@file[$i],0,1) eq "#"){
			$activity=@file[$i];
			$activity=~ s/#//gi;
		}else{
			if(substr(@file[$i],0,1) eq "%"){
				@temp=split("\t", @file[$i]);
				$name=@temp[0];
				$name=~ s/\%//gi;
				@temp2=split(/\+/, $name);
				if($#temp2 == 0){
					$hash{"$activity"}{"$name"}="";
					if($#temp >=1){
						$hash{"$activity"}{"$name"}=@temp[1];
					}
				}else{
					if (!exists($hash{"$activity"}{"MergePanels"}{"contador"})){
						$hash{"$activity"}{"MergePanels"}{"contador"}=-1;
					}
					$hash{"$activity"}{"MergePanels"}{"contador"}++;
					$count=$hash{"$activity"}{"MergePanels"}{"contador"};
					foreach $j (0..$#temp2){
						$hash{"$activity"}{"MergePanels"}{$count}{$j}=@temp2[$j];
					}
				}
			}else{
				if($activity eq "Chunk"){
					if(@file[$i] ne ""){
						$hash{"$activity"}=@file[$i];
					}
				}
				if($activity eq "Interval"){
					if(@file[$i] ne ""){
						$hash{"$activity"}=@file[$i];
					}
				}
				if($activity eq "OnlyPhase"){
					if(@file[$i] ne ""){
						$hash{"$activity"}=@file[$i];
					}
				}
			}
		}
	
	}
	
	if(exists($hash{"OnlyPhase"})){
		if(exists($hash{"Impute"})){
			die("Erro:A Flag Imputar e OnlyPhase não podem estar juntamente no arquivo\n");
		}else{
			if(exists($hash{"Panels"})){
				die("Erro: OnlyPhase não pode ter paineis\n");
			}else{
				@keys=keys(%{$hash{"OnlyPhase"}});
				foreach $i (0..$#keys){
					$hash{"Impute"}{@keys[$i]}="";
				}
				$dontImpute=1;
			}
		}
	}
	
	#print Dumper %hash;
	#<STDIN>;
}

sub addExclude(){
	@listExclude[$#listExclude+1]=@_[0];
	print "\n";
	#print Dumper @listExclude;
}

sub run{
	my $linha = @_[0];
	my (@threads);
	my($j, $count);
	
	$linha=~ s/\n//gi;
	if($imputation==0){
		if($teste){
			print "$linha\n";
			#print Dumper %hash;
			if(!$print){
				system ($linha);
			}
			<STDIN>;
		}else{
			system ($linha);
		}
	}else{
		$count=$#buffer+1;
		if ($count < $threadsImputation-1 && $concluido==0){
			@buffer[$count]=$linha;
			$count++;
		}else{
			if($count == $threadsImputation-1){
				print "\t Buffer cheio\n";
			}else{
				if($concluido==1){
					print "\t Todos paineis já foram contemplados\n";
				}
			}
			@buffer[$count]=$linha;
			foreach $j (0..$#buffer){
				@threads[$j]= threads->create(\&runThread, @buffer[$j], $j);
			}
			foreach $j(0..$#threads){
				@threads[$j]->join();
			}
			@buffer=();
			$count=0;
		}
	}
}

sub runThread{
	my $linha = @_[0];
	my $id=@_[1];
	my @temp;
	
	#print "Criando LogLinha$id.txt\n";
	#open (OF,">>LogLinha$id.txt");
	if($linha ne ""){
		@temp=split("-o ", $linha);
		@temp=split("/",@temp[$#temp]);
		
		$linha=$linha." > $output/Log@temp[$#temp].txt";
		
		if($teste){
			print "$linha\n";
			if(!$print){
				system ($linha);
			}
			#<STDIN>;
		}else{
			system ($linha);
		}
	}
	#print "Encerrando o @temp[$#temp]\n";

}

sub endTheProgram{
	my ($string);	
	$string=@_[0];
	
	die($string);
}

sub showHelp(){
  print "\n";
  print "=========================================================================================\n";
  print "**                                                                                     **\n";
  print "**                                                                                     **\n";
  print "** Opcoes:                                                                             **\n";
  print "**                                                                                     **\n";
  print "**	-input <File>				File with data description	 	**\n";
  print "**						Ex: File1.txt				**\n";
  print "**										 	**\n";
  print "**	-output <Path>				Folder where results will be saved 	**\n";
  print "**										 	**\n";
  print "**	-path <File>				File with programs path		 	**\n";
  print "**						Ex: File2.txt				**\n";
  print "**										 	**\n";
  print "**	-start <number>				First chromossome of interval	 	**\n";
  print "**										 	**\n";
  print "**	-end <number>				Last chromossome of interval		**\n";
  print "**										 	**\n";
  print "**	-seed <number>				Seed of shapeit (optional)	 	**\n";
  print "**										 	**\n";
  print "**	-states <number>			States of shapeit (optional)	 	**\n";
  print "**										 	**\n";
  print "**	-bed 					This option tells the algorithm that 	**\n";
  print "**						the data is in the bed/bim/fam format	**\n";
  print "**						(ped/map is the default)	 	**\n";
  die ("=========================================================================================\n");
}

