% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smrterTraditionalControl.R
\name{smrterTraditionalControl}
\alias{smrterTraditionalControl}
\title{smrterTraditionalControl}
\usage{
smrterTraditionalControl(case_path, cont_path, sitesInfo_interest = NULL,
  split_chunk_num = 2000, cores = 20, type = "callMod",
  coverage_per_molecule = 5, number_of_molecule = 10,
  case_coverage = coverage_per_molecule * number_of_molecule,
  cont_coverage = 20, score_thres = 20)
}
\arguments{
\item{case_path}{a character value indicating the file path of cmp.h5 file for native DNA}

\item{cont_path}{a character value indicating the file path of cmp.h5 file for WGA}

\item{sitesInfo_interest}{a data frame of smrt data indicating the sites of interest for the single molecule analysis. It should cover the basic information for those sites, including at least "refName", "strand", "tpl", and "modelPrediction"}

\item{split_chunk_num}{an integer value indicating the number of split chunks for parallel computing}

\item{cores}{an integer value indicating the number of computer cores for parallel computing}

\item{type}{a character values indicating the types of analysis. It takes on either "callMod" or "SMipdRatio", where "callMod" represents calling methylation fraction, and "SMipdRatio" represents collecting IPD ratio of single molecule for the following analysis}

\item{coverage_per_molecule}{an integer value indicating the threshold of number of subreads covering one single site from one molecule in native DNA}

\item{number_of_molecule}{an integer value indicating the threshold of number of molecules covering one single site in native DNA}

\item{case_coverage}{an integer value indicating the threshold of number of subreads covering one single site from all molecules in native DNA}

\item{cont_coverage}{an integer value indicating the threshold of number of subreads covering one single site from all molecules in WGA}

\item{score_thres}{an integer value indicating the threshold of modification score to filter sites of interest}
}
\value{
the type of "callMod" returns a list with the name of refName and strand "refName.strand". Each item is a data frame comprising the following columns:
\itemize{
 \item {tpl} an integer value indicating the genomic location 
 \item {caseMean} a numeric value indicating mean of normalized case IPDs observed at this position (AGG)
 \item {caseStd} a numeric value indicating the standard deviation of case IPDs observed at this position
 \item {controlMean} a numeric value indicating the mean of normalized control IPDs observed at this position (AGG)
 \item {controlStd} a numeric value indicating the standard deviation of control IPDs observed at this position
 \item {coverage} an integer value indicating the mean of case and control coverage
 \item {caseCoverage} an integer value indicating count of valid case IPDs at this position
 \item {controlCoverage} an integer value indicating count of valid control IPDs at this position
 \item {molNum} an integer value indicating the count of valid case molecules
 \item {ipdRatio} a numeric value indicating caseMean / controlMean
 \item {score} an integer value indicating the Phred-transformed pvalue of modification detection, i.e. 10*(-log10(pvalue))
 \item {ipdRatio2} a numeric value indicating the mean ipd Ratio of modified molecules at a single site. 
 Two Gaussian mixture models are learned for unmodified and modified distributions, 
 where the mean for the unmodified distribution is fixed as 1, 
 and the mean for the modified is learned (i.e., ipdRatio2)
 \item {frac} a numeric value indicating the fraction of modified molecules at a single site estimated from the single molecule level
}
the type of "SMipdRatio" returns a list with the name of refName and strand "refName.strand". Each item is a data frame comprising the following columns:
\itemize{
 \item {tpl} an integer value indicating the genomic location 
 \item {ipdRatio} a numeric value indicating the IPD ratio at this position of one specific molecule
}
}
\description{
smrterTraditionalControl calls methylation fraction at single molecule level with WGA control
}
\examples{


}
