% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapWithBed.R
\name{overlapWithBed}
\alias{overlapWithBed}
\title{overlapWithBed}
\usage{
overlapWithBed(smrt, bed, chr = "chr", start = "start", end = "end",
  genome_size, coverage_thres = c(10, 20, 21, 30), score_thres = c(20, 30,
  31, 40), meth_base = "A", tags = NULL, cores = 10)
}
\arguments{
\item{smrt}{a data frame of SMRT smrt data, indicating the putative DNA modifications detected by SMRT}

\item{bed}{a data frame comprising at least chr, start, end, indicating the regions of DNA modifications detected by other techniques, e.g., DIPseq}

\item{genome_size}{an integer value indicating the size of genome}

\item{coverage_thres}{a vector of integer values, indicating the list of thresholds for read coverage}

\item{score_thres}{a vector of integer values, indicating the list of thresholds for modification detection scores}

\item{meth_base}{a character value, indicating the methylated base, by default, "A"}

\item{tags}{a vector of character values, indicating the types of modifications. If NULL, overlapWithBed() checks all types of modifications for that base indicated by "meth_base"}

\item{cores}{an integer value indicating the number of computer cores for parallel computing}
}
\value{
a data frame comprising the following columns
\itemize{
 \item {total_smrt} an integer value indicating the number of putative modifications by SMRTseq
 \item {overlap_smrt} an integer value indicating the number of SMRTseq-detected modifications which are also supported by other techniques
 \item {observed_ratio} a numeric value indicating the observed fraction of SMRTseq-detected modifications supported by other techniques 
 \item {expected_ratio} a numeric value indicating the expected fraction of SMRTseq-detected modifications supported by other techniques 
 \item {fold_enrich} the odds ratio beteween observed_ratio and expected_ratio
 \item {pval} the p value for the significance of overlap between SMRTseq and other techniques compared with the random chance
}
}
\description{
overlapWithBed checks the intersection of DNA modifications between SMRTseq and other detection methods
}
\examples{

}
\seealso{
\code{\link{readSmrtGff}}; \code{\link{readSmrtCsv}};
}
