% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConsensus.R
\name{getConsensus}
\alias{getConsensus}
\title{getConsensus}
\usage{
getConsensus(smrt, annot, window = 1000, chr = "chr", strand = "strand",
  start = "start", criterion = "ipdRatio", smooth = 0, cores = 1)
}
\arguments{
\item{smrt}{a data frame of smrt data, taking at least columns: refName, strand, tpl, ipdRatio/score}

\item{annot}{a data frame of annotation giving the genomic locations of the biological elements of interest}

\item{window}{an integer value indicating the size of flanking region (bp)}

\item{chr}{a character value indicating the name of the column representing the "chromosome" in the annotation}

\item{strand}{a character value indicating the name of the column representing the "strand" in the annotation}

\item{start}{a character value indicating the name of the column representing the "start" in the annotation}

\item{criterion}{a character value taking on either "ipdRatio" or "score", by default, "ipdRatio"}

\item{smooth}{an integer value indicating the size of sliding window for smoothing}

\item{cores}{an integer value indicating the number of computer cores for parallel computing}
}
\value{
a vector of numeric value (2*window+1 long), representing the consensus of the criterion (by default, ipdRatio) around the start sites of the biological elements
}
\description{
getConsensus performs the DNA modification consensus analysis along the biological elements of interest
}
\examples{

}
\seealso{
\code{\link{readSmrtGff}}; \code{\link{readSmrtCsv}};
}
