% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callMotif.R
\name{callMotif}
\alias{callMotif}
\title{callMotif}
\usage{
callMotif(nat = NULL, split_nat = NULL, wga = NULL, split_wga = NULL,
  genome, kmer = 4, meth_char = "A", cores = 10, criterion = "ipdRatio",
  thres = 4)
}
\arguments{
\item{nat}{a data frame of smrt data for native DNA, taking at least columns: refName, strand, tpl, ipdRatio/score}

\item{split_nat}{a list of smrt for native DNA, which is a split smrt generated by the function splitSmrt()}

\item{wga}{a data frame of smrt data for WGA, taking at least columns: refName, strand, tpl, ipdRatio/score}

\item{split_wga}{a list of smrt for WGA, which is a split smrt generated by the function splitSmrt()}

\item{genome}{a DNAStringSet value indicating the reference sequence. Refer to Biostrings:readDNAStringSet()}

\item{kmer}{an integer value indicating the motif length of interest}

\item{meth_char}{a character value indicating the methylated base, by default "A"}

\item{cores}{an integer value indicating the number of cores for parallel computating}

\item{criterion}{a character value indicating the criterion for calling motif, either "ipdRatio" or "score", and by default, "ipdRatio"}

\item{thres}{a numeric value indicating the threshold for the criterion, by default, 4 for ipdRatio}
}
\value{
a list comprising the following components
\itemize{
 \item {nat_motif_fdr} a data frame indicating the motif enrichment score for each k-mer motif in native DNA
 \item {wga_motif_fdr} a data frame indicating the motif enrichment score for each k-mer motif in WGA
 \item {adjust_motif_fdr} a data frame indicating the adjusted motif enrichment score by comparing native DNA with WGA
}
}
\description{
callMotif calculates in parallel the motif enrichment scores for all k-mer motifs in native DNA, when only smrt data for native DNA is specified (either nat or split_nat);
it can also calculate the adjusted motif enrichment scores by comparing native DNA with WGA, when smrt data for both native DNA and WGA are specified (nat/split_nat and wga/split_wga).
}
\examples{

}
\seealso{
\code{\link{callFDR_eachMotif}}; \code{\link{enumerateMotif}};
}
