% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callFDR_eachMotif.R
\name{callFDR_eachMotif}
\alias{callFDR_eachMotif}
\title{callFDR_eachMotif}
\usage{
callFDR_eachMotif(smrt = NULL, split_smrt = NULL, genome, kmer = 4,
  meth_char = "A", cores = 10, criterion = "ipdRatio", thres = 4)
}
\arguments{
\item{smrt}{a data frame, taking at least columns: refName, strand, tpl, ipdRatio/score}

\item{split_smrt}{a list of smrt, which is a split smrt generated by the function splitSmrt()}

\item{genome}{a DNAStringSet value indicating the reference sequence. Refer to Biostrings:readDNAStringSet()}

\item{kmer}{an integer value indicating the motif length of interest}

\item{meth_char}{a character value indicating the methylated base, by default "A"}

\item{cores}{an integer value indicating the number of cores for parallel computating}

\item{criterion}{a character value indicating the criterion for calling motif, either "ipdRatio" or "score", and by default, "ipdRatio"}

\item{thres}{a numeric value indicating the threshold for the criterion, by default, 4 for ipdRatio}
}
\value{
a data frame comprising the following columns
\itemize{
 \item {motif} a character value indicating the methylation motifs
 \item {pos} an integer indicating the methylation position in the motif
 \item {score} a numeric value indicating the motif enrichment score for the corresponding motif
}
}
\description{
callFDR_eachMotif calculates in parallel the motif enrichment scores for all k-mer motifs
}
\examples{

}
\seealso{
\code{\link{splitSmrt}}; \code{\link{callFDR}}; \code{\link{enumerateMotif}};
}
