% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMM2.R
\name{GMM2}
\alias{GMM2}
\title{GMM2}
\usage{
GMM2(x, mu, fixed = c(1:length(mu)))
}
\arguments{
\item{x}{a vector of numeric values}

\item{mu}{a vector of values indicating the means of mixture models}

\item{fixed}{a vector of values indicating the index of}
}
\value{
a list of values comprising the following components
\itemize{
 \item {G} an integer value indicating the number of Gaussian mixture models
 \item {lamda} a vector of numeric values indicating the propotion of each mixture model
 \item {mu} a vector of numeric values indicating the mean of each mixture model
 \item {sd} a vector of numeric values indicating the standard deviation of each mixture model
}
}
\description{
GMM2 estimates the Gaussian mixture models
}
\examples{

x1 <- rnorm(300,mean=1,sd=0.5)
x2 <- rnorm(700,mean=4,sd=1)
x <- c(x1,x2)
plot(density(x))

# fix both two means
GMM2(x,mu=c(1,4),fixed=c(1,2) )
# fix one mean, and estimate the other 
GMM2(x,mu=c(1,10),fixed=c(1) )
# do not fix means, and estimate both
GMM2(x,mu=c(0,10),fixed=c() )


}
