
fetchChunks = function( job , refId , strand , feature='IPD' )
{
  cmpH5 = job$cmpH5
  index = job$index
  accuracy = job$accuracy # QVs include probability of substitution, deletion, insertion and pulse merging
  readlength = job$readlength
  
  ##################################################
  ############# subread filtering ##################
  ##################################################
  chunk_idx =  which( readlength > 50 & index$mapQV > 240 &  accuracy > 0.75 & 
                        as.character(index$fullRefName) == refId & index$alignedStrand == strand )
  # Mapping QV generated by BLASR
  cat( 'molecule num from index:' , length(chunk_idx) , '\n') 
  chunk_index = index[chunk_idx,]
  
  #################################################
  if( feature=='IPD' )
    system.time( ipd <- getIPD(cmpH5,idx=chunk_idx,unit='seconds') ) # next, downsampling and divided by frame
  if( feature=='PulseWidth' )
    system.time( ipd <- getPulseWidth(cmpH5,idx=chunk_idx,unit='seconds') ) # next, downsampling and divided by frame
  
  system.time( position <- getTemplatePosition(cmpH5,idx=chunk_idx) ) 
  system.time( alignment <- getAlignments(cmpH5,idx=chunk_idx) )
  # alignment is at read strand, while index has been changed to template strand
  
  ##################################################
  ############# sites filtering ####################
  ##################################################
  system.time( mismatched <- lapply( alignment , function(x) { which( x[,'read']=='-' | x[,'reference']=='-')  } ) ) # what kineticsTools does 
  # system.time( mismatched <- lapply( alignment , function(x) { which( x[,'read'] != x[,'reference'])  } ) )
  ipd = lapply( 1:length(ipd) , function(i) {ipd[[i]][-mismatched[[i]]]}  )
  position = lapply( 1:length(position) , function(i) {position[[i]][-mismatched[[i]]]}  )
  #alignment = lapply( 1:length(alignment) , function(i) {alignment[[i]][-mismatched[[i]],]}  )
  
  ##################################################
  #### subread capping and normalization ###########
  ##################################################
  system.time( norm_ipd <- lapply( ipd, function(x){ x/subreadNormalizationFactor(x)}) )  # Capping 2
  
  ##################################################
  ### globally sites capping ##############
  ##################################################
  all_norm_ipd = do.call(c,norm_ipd)
  all_position = do.call(c,position)
  all_molecule = rep( chunk_index$moleculeID, sapply(position,length) )
  #all_subread  = rep( chunk_idx, sapply(position,length) )
  # globalPercentile = ifelse( length(all_norm_ipd)<10 , 5.0 , quantile( all_norm_ipd , 0.99 ,na.rm=TRUE ) )
  
  #chunk_info = data.frame( normIpd = all_norm_ipd , tpl = all_position , moleculeID = all_molecule , subreadID = all_subread)
  chunk_info = data.frame( normIpd = all_norm_ipd , tpl = all_position , moleculeID = all_molecule )
  chunk_info
}



fetchChunks2 = function( job , refId, strand , start=NULL , end=NULL )
{
  cmpH5 = job$cmpH5
  index = job$index
  accuracy = job$accuracy
  readlength = job$readlength
  
  ##################################################
  ############# subread filtering ##################
  ##################################################
  if( !is.null(start) & !is.null(end) )
  { 
    chunk_idx =  which( readlength > 50 & index$mapQV > 240 &  accuracy > 0.75 & 
                          as.character(index$fullRefName) == refId & index$alignedStrand == strand & 
                          index$tStart <= end & index$tEnd >= start )
  } else {
    
    chunk_idx =  which( readlength > 50 & index$mapQV > 240 &  accuracy > 0.75 & 
                          as.character(index$fullRefName) == refId & index$alignedStrand == strand )
  }	
  
  cat( 'molecule num from index:' , length(chunk_idx) , '\n') 
  chunk_index = index[chunk_idx,]
  
  #################################################
  system.time( ipd <- getIPD(cmpH5,idx=chunk_idx,unit='seconds') ) # next, downsampling and divided by frame
  system.time( position <- getTemplatePosition(cmpH5,idx=chunk_idx) ) 
  system.time( alignment <- getAlignments(cmpH5,idx=chunk_idx) )
  
  ##################################################
  ############# sites filtering ####################
  ##################################################
  system.time( mismatched <- lapply( alignment , function(x) { which( x[,'read']=='-' | x[,'reference']=='-')  } ) ) # what kineticsTools does 
  # system.time( mismatched <- lapply( alignment , function(x) { which( x[,'read'] != x[,'reference'])  } ) )
  ipd = lapply( 1:length(ipd) , function(i) {ipd[[i]][-mismatched[[i]]]}  )
  position = lapply( 1:length(position) , function(i) {position[[i]][-mismatched[[i]]]}  )
  #alignment = lapply( 1:length(alignment) , function(i) {alignment[[i]][-mismatched[[i]],]}  )
  
  ##################################################
  #### subread capping and normalization ###########
  ##################################################
  system.time( norm_ipd <- lapply( ipd, function(x){ x/subreadNormalizationFactor(x)}) )  # Capping 2
  
  ##################################################
  ### globally sites capping ##############
  ##################################################
  all_norm_ipd = do.call(c,norm_ipd)
  all_position = do.call(c,position)
  all_molecule = rep( chunk_index$moleculeID, sapply(position,length) )
  
  # globalPercentile = ifelse( length(all_norm_ipd)<10 , 5.0 , quantile( all_norm_ipd , 0.99 ,na.rm=TRUE ) )
  
  chunk_info = data.frame( normIpd = all_norm_ipd , tpl = all_position , moleculeID = all_molecule )
  
  if( !is.null(start) & !is.null(end) )
  { 
    chunk_info = chunk_info[ !is.na(chunk_info$normIpd) & chunk_info$tpl >=start & chunk_info$tpl < end ,  ]
  }
  
  chunk_info
}
