#this script removes reads that map to - strand
# Written by Stephen Tran (@ Grace Xiao's lab, UCLA)


import sys
import re
from itertools import islice

number_lines_to_read_in = 1000000 #lets read in and process 1 million lines at a time
while True:
#for line in sys.stdin:
	next_n_lines = list(islice(sys.stdin,number_lines_to_read_in))
	#debugging line
	if not next_n_lines:
		break #this is how I'll know when EOF
	sam_list = list() #to hold the buffered sam files	
	for line in next_n_lines:
		line_info = line.split('\t')
		strand = line_info[1]
		bit_strand = format(int(strand),'#014b')[2:] 
		if bit_strand[-5] == "1": #minus strand
			continue #do not print out this read b/c it maps to - strand
		elif bit_strand[-5] == "0": #+ strand
			sam_list.append(line)
		else:
			sys.stderr.write( "cannot determine strand of this read\n"+line+'\n')
			sys.exit(1)
	sys.stdout.write("".join(sam_list))
	
sys.stderr.write( 'job completed removing - strand reads\n')
