library(ggplot2)
library(RColorBrewer)
theme_set(theme_bw())

b<-brewer.pal(12,"Paired")
fuckit<-c("grey50","#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#a65628","#f781bf")
cbbPalette<-fuckit

t<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-12-coactivation/rawdata/enrichments/enrichments.forr.txt")
names(t)<-c("condition","replicate","generation","family","rpm","enrichment")
t$color=0
t$condition<-factor(t$condition,levels=c("hot","cold"))
t <- rbind(t[t$family!="P-element",], t[t$family=="P-element",])
t <- rbind(t[t$family!="Mariner",], t[t$family=="Mariner",])
t <- rbind(t[t$family!="blood",], t[t$family=="blood",])
t <- rbind(t[t$family!="pogo",], t[t$family=="pogo",])
t <- rbind(t[t$family!="Transpac",], t[t$family=="Transpac",])
t <- rbind(t[t$family!="hopper",], t[t$family=="hopper",])
t <- rbind(t[t$family!="BS",], t[t$family=="BS",])


t[t$family=="P-element",]$color<-1
t[t$family=="Mariner",]$color<-2
#t[t$family=="blood",]$color<-3
#t[t$family=="pogo",]$color<-4
#t[t$family=="Transpac",]$color<-5
#t[t$family=="hopper",]$color<-6
t[t$family=="BS",]$color<-7 
#pink

#BS4
#G7
#accord

t$color=as.factor(t$color)



g<-ggplot(t,aes(x=generation,y=enrichment,group=family,color=color))+geom_line()+geom_point()+facet_grid(replicate~condition,scales="free_x", space = "free_x")+theme(legend.position="none")+
  scale_colour_manual(values=cbbPalette)+ylab("relative increase")
postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-12-coactivation/graph/coactivation-mablue-bsgre.eps",width=5,height=3.8)
plot(g)
dev.off()
