summarySE <- function(data=NULL, measurevar, groupvars=NULL, na.rm=FALSE,
                      conf.interval=.95, .drop=TRUE) {
  library(plyr)
  
  # New version of length which can handle NA's: if na.rm==T, don't count them
  length2 <- function (x, na.rm=FALSE) {
    if (na.rm) sum(!is.na(x))
    else       length(x)
  }
  
  # This does the summary. For each group's data frame, return a vector with
  # N, mean, and sd
  datac <- ddply(data, groupvars, .drop=.drop,
                 .fun = function(xx, col) {
                   c(N    = length2(xx[[col]], na.rm=na.rm),
                     mean = mean   (xx[[col]], na.rm=na.rm),
                     sd   = sd     (xx[[col]], na.rm=na.rm)
                   )
                 },
                 measurevar
  )
  
  # Rename the "mean" column    
  datac <- rename(datac, c("mean" = measurevar))
  
  datac$se <- datac$sd / sqrt(datac$N)  # Calculate standard error of the mean
  
  # Confidence interval multiplier for standard error
  # Calculate t-statistic for confidence interval: 
  # e.g., if conf.interval is .95, use .975 (above/below), and use df=N-1
  ciMult <- qt(conf.interval/2 + .5, datac$N-1)
  datac$ci <- datac$se * ciMult
  
  return(datac)
}


library(ggplot2)
#library(gridExtra)
ls=0.8

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
fuckit2<-c("black","red","#4daf4a")
fuckit3<-c("blue","red")
cbbPalette <- fuckit3
theme_set(theme_bw())

em<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/data/ss52/endres/summary.txt")
names(em)<-c("rep","gen","condition","count")
ems<-summarySE(em,measurevar="count",groupvars = c("condition","gen"))


dodge <- position_dodge(width=9)
p<-ggplot(ems,aes(x=gen,y=count,fill=condition))+geom_bar(position="dodge",stat="identity")+geom_errorbar(aes(ymin=count-sd,ymax=count+sd),width=3,position = dodge)+
  scale_fill_manual(values=cbbPalette)+theme(legend.position=c(0.2,0.7))

postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/graphs/trunc-abundance.ps",width=3,height=3)

plot(p)
dev.off()
#p<-ggplot(em,aes(x=pos,y=enrichment))+geom_line(size=ls)+theme(legend.position="none")+geom_hline(yintercept=1.0,linetype="dashed")+
#  xlab("Position in P-element")+ylab("Fitness effect of deletion")+facet_grid(.~condition,scales="free_x", space = "free_x")
#postscript(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-11-truncations/graphs/enrichment.ps",width=8,height=4)

#plot(p)

#dev.off()

