library(ggplot2)
library(gridExtra)
library(RColorBrewer)

b<-brewer.pal(12,"Paired")
fuckit<-c("grey50","#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#a65628","#f781bf")
cbbPalette<-fuckit
#names(cc)<-c("key","number")

traj<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/01-abundancetrajectories/truncation-trajectories-for-R.txt")
ov<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/01-abundancetrajectories/truncation-overview-for-R-merged.txt")
cc<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/01-abundancetrajectories/truncfreqs/truncation-color-code.txt")



names(traj)<-c("condition","replicate","key","generation","popfreq")
names(ov)<-c("condition","num","position","key","basepresent")


# hot	1	474-762	60	0.0461865504661
# hot	1	192-2555	60	0.0422557802136
# hot	3	636-2255	60	0.0636905785629
# hot	3	1352-1665	60	0.0378162810217
# hot	5	153-2510	40	0.0404888883035
# cold	1	192-2555	40	0.0303965697224
# cold	1	187-1959	40	0.0303965697224
# cold	1	188-1960	20	0.046041267121
# cold	3	362-2598	40	0.0476152332799
# cold  3	187-1959	30	0.044885383152
# cold	3	188-1960	20	0.0312561317651


# grey, red, blue,green,violet,orange

traj$color=0
traj[traj$key=="188-1960",]$color<-1
traj[traj$key=="187-1959",]$color<-1
traj[traj$key=="192-2555",]$color<-2
traj[traj$key=="362-2598",]$color<-3
traj[traj$key=="153-2510",]$color<-4
traj[traj$key=="1352-1665",]$color<-5
traj[traj$key=="636-2255",]$color<-6
traj[traj$key=="474-762",]$color<-7
traj$color=as.factor(traj$color)

ov$color=0
ov[ov$key=="188-1960",]$color<-1
ov[ov$key=="187-1959",]$color<-1
ov[ov$key=="192-2555",]$color<-2
ov[ov$key=="362-2598",]$color<-3
ov[ov$key=="153-2510",]$color<-4
ov[ov$key=="1352-1665",]$color<-5
ov[ov$key=="636-2255",]$color<-6
ov[ov$key=="474-762",]$color<-7
ov$color=as.factor(ov$color)

# for KP and D50
ov$lwd=1
ov[ov$key=="808-2560",]$lwd<-1
ov[ov$key=="819-2527",]$lwd<-1


#   1 1352-1665
#3 153-2510
#3 187-1959
#6 188-1960
#8 192-2555
#2 362-2598
#5 474-762
#4 636-2255


traj$condition<-factor(traj$condition,levels=c("hot","cold"))
ov$condition<-factor(ov$condition,levels=c("hot","cold","P"))
ov$basepresent<-factor(ov$basepresent)

theme_set(theme_bw())
g<-ggplot(traj,aes(x=generation,y=popfreq,group=key,color=color))+geom_line()+geom_point()+facet_grid(replicate~condition,scales="free_x", space = "free_x")+theme(legend.position="none")+
  scale_colour_manual(values=cbbPalette)+ylab("frequency of truncation")

# overview
o<-ggplot(ov,aes(x=position,y=num,group=num,color=color,linetype=basepresent))+geom_line()+facet_grid(condition ~ . ,scales="free_y", space="free_y")+
  theme(legend.position="none",axis.title.y=element_blank(),axis.text.y=element_blank(),axis.ticks.y = element_blank())+scale_colour_manual(values=cbbPalette)+
  scale_linetype_manual(values=c("solid", "longdash"))

grid.arrange(o,g,ncol=2,nrow=1,widths=c(1,2),heights=c(1))
dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/graphs/truncation-overview.eps")

