library(ggplot2)
library(gridExtra)
ls=0.8

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
fuckit2<-c("black","red","#4daf4a")
cbbPalette <- fuckit2
theme_set(theme_bw())

em<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/01-abundancetrajectories/enrichment/enrichment-baseincluded.txt")
names(em)<-c("pos","cov","wcov","enrichment")

g<-ggplot(em,aes(x=pos))+geom_line(size=ls,aes(y=cov,colour="unweighted"))+geom_line(size=ls,aes(y=wcov,colour="weighted"))+
  theme(legend.position=c(0.9,0.7),axis.title.x=element_blank(),axis.text.x=element_blank())+
  scale_colour_manual(values=cbbPalette)+labs(fill="Cond.")+ylab("scaled coverage")

o<-ggplot(em,aes(x=pos,y=1/enrichment))+geom_line(size=ls)+theme(legend.position="none")+geom_hline(yintercept=1.0,linetype="dashed")+
  xlab("Position in P-element")

grid.arrange(g,o,ncol=1,nrow=2,widths=c(1),heights=c(1,2))

dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/graphs/truncation-fitness-landscape.eps")




