library(ggplot2)
library(cowplot)
#library(gridExtra)
ls=0.8

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
fuckit2<-c("black","red","#4daf4a")
cbbPalette <- fuckit2
theme_set(theme_bw())
em<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/06-comparedeletionpattern/joint.enrichment.txt")
names(em)<-c("condition","pos","cov","wcov","enrichment")
em$condition <- factor(em$condition, levels=c("hot","cold"))


ymax=max(em$enrichment)
  
  
p2<-ggplot(em,aes(x=pos,y=cov))+geom_line(size=ls)+theme(legend.position="none")+xlab("Position in P-element")+ylab("internal deletions per site")+
  facet_grid(.~condition,scales="free_x", space = "free_x")

p<-ggplot(em,aes(x=pos,y=enrichment))+geom_line(size=ls)+theme(legend.position="none")+
  xlab("Position in P-element")+ylab("average pop.freq")+facet_grid(.~condition,scales="free_x", space = "free_x")+scale_y_log10()+
  annotate("rect",xmin=1,xmax=136,ymin=0,ymax=ymax,alpha=0.3,fill="green")+annotate("rect",xmin=2763,xmax=2907,ymin=0,ymax=ymax,alpha=0.3,fill="green")


pdf(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/06-comparedeletionpattern/truncation-comparision.pdf",width=7,height=7)
p<-plot_grid(p2,p,labels = "AUTO", ncol = 1, align = 'v',axis='l')
plot(p)
dev.off()



