library(ggplot2)
library(gridExtra)
ls=0.8

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
cbbPalette <- fuckit
theme_set(theme_bw())

#em<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/02-gsnap-sss/truncation-emergence.txt")

em<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/04-gsnap-ss/truncation-emergence.txt")
names(em)<-c("condition","replicate","key","emergence","basepresent")
em$replicate<-as.factor(em$replicate)
em$count=1

emc<-aggregate(count~emergence+replicate,data=em,FUN=length)

# no basepresent
emnbp<-em[em$basepresent==0,]
emcnbp<-aggregate(count~emergence+replicate,data=emnbp,FUN=length)
emcnbp<-rbind(emcnbp,c(60,5,0))


emp<-ggplot(emcnbp,aes(x=emergence,y=count,color=replicate))+geom_line(size=ls)+geom_point()+ylim(0,20)+
 scale_colour_manual(values=cbbPalette)+ylab("observed truncations")+theme(legend.position=c(0.9,0.8))
plot(emp)


dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/graphs/emergence-plot-ss.eps")