library(ggplot2)
library(gridExtra)
library(lme4)


theme_set(theme_bw())
t<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/02-rpm-hotcold/rnaseq.txt")
names(t)<-c("evolved","replicate","cg","rpm")

mod1<-lmer(rpm~evolved+cg + (1|replicate),t)
mod2<-lmer(rpm~evolved+ (1|replicate),t)
print(anova(mod1,mod2))


#First mixed model models the temperature (cge) effect as fixed and replicate effect as random. You will probably get a significant cge effect here already.
#data is a data.frame with columns evolved, rep, temperature and rpm
#you should log10 transform the rpms to ensure normality, just in case
#mod1=lmer(log10(rpm) ~ temperature + (1|rep), data)

#Second model model only random effects
#mod2=lmer(log10(rpm) ~ (1|rep), data)

#Here you compare the two models. If model1 fits better significantly (and it will) take the p-value from anova
#anova(mod1,mod2)
