library(ggplot2)
library(gridExtra)
library(lme4)


theme_set(theme_bw())
tot<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/03-significance/invasion/raw-invasion-extended.txt")
names(tot)<-c("evolved","replicate","generation", "sex","rawreads","bullshitrpm","rpm","increase")

cold<-subset(tot,evolved=="cold")
hot <-subset(tot,evolved=="hot")

# hot	1	0	f	2363	16.98	15.95	na

mod1<-lmer(rpm~ (1|replicate),hot)
mod2<-lmer(rpm~generation+ (1|replicate),hot)
print(anova(mod1,mod2))

mod1<-lmer(rpm~ (1|replicate),cold)
mod2<-lmer(rpm~generation+ (1|replicate),cold)
print(anova(mod1,mod2))


#First mixed model models the temperature (cge) effect as fixed and replicate effect as random. You will probably get a significant cge effect here already.
#data is a data.frame with columns evolved, rep, temperature and rpm
#you should log10 transform the rpms to ensure normality, just in case
#mod1=lmer(log10(rpm) ~ temperature + (1|rep), data)

#Second model model only random effects
#mod2=lmer(log10(rpm) ~ (1|rep), data)

#Here you compare the two models. If model1 fits better significantly (and it will) take the p-value from anova
#anova(mod1,mod2)
