library(ggplot2)
library(gridExtra)
ls=0.8

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
fuckit2<-c("black","red","#4daf4a")
cbbPalette <- fuckit2
theme_set(theme_bw())

em<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-11-truncations/data/gsnap-raw/enrichment/joint-hotcold.txt")
names(em)<-c("condition","pos","cov","wcov","enrichment")

#g<-ggplot(em,aes(x=pos))+geom_line(size=ls,aes(y=cov,colour="unweighted"))+geom_line(size=ls,aes(y=wcov,colour="weighted"))+
#  theme(legend.position=c(0.9,0.7),axis.title.x=element_blank(),axis.text.x=element_blank())+
#  scale_colour_manual(values=cbbPalette)+labs(fill="Cond.")+ylab("scaled coverage")

p<-ggplot(em,aes(x=pos,y=enrichment))+geom_line(size=ls)+theme(legend.position="none")+geom_hline(yintercept=1.0,linetype="dashed")+
  xlab("Position in P-element")+ylab("Fitness effect of deletion")+facet_grid(condition~.,scales="free_x", space = "free_x")
postscript(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-11-truncations/graphs/enrichment.ps",width=5,height=7)

plot(p)
#grid.arrange(g,o,ncol=1,nrow=2,widths=c(1),heights=c(1,2))
dev.off()
#dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/graphs/truncation-fitness-landscape.eps")




