library(ggplot2)
library(RColorBrewer)
theme_set(theme_bw())

b<-brewer.pal(12,"Paired")
fuckit<-c("grey50","#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#a65628","#f781bf")
cbbPalette<-fuckit

t<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/data/truncpositions/finaldata/sumfirst.forR")
# hot	1	60	2L	19789989	P-element	0.023	0
# hot	1	60	2L	2823313	P-element	0.101	0
# hot	1	60	2L	19102234	P-element	0.021	0

names(t)<-c("condition","replicate","generation","chromosome","position","family","popfreq","truncated")
t$color=0
t$trunclabel<-"no trunc."
t[t$truncated==1,]$trunclabel<-"trunc."
t$trunclabel=as.factor(t$trunclabel)

#t$condition<-factor(t$condition,levels=c("hot","cold"))
#t <- rbind(t[t$family!="PPI251",], t[t$family=="PPI251",])
# t <- rbind(t[t$family!="Mariner",], t[t$family=="Mariner",])


#t[t$family=="PPI251",]$color<-1
# t[t$family=="Mariner",]$color<-2
#pink

#BS4
#G7
#accord

t$color=as.factor(t$color)
t$truncated=as.factor(t$truncated)
yestr<-t[t$truncated==1,]$popfreq
notr<-t[t$truncated==0,]$popfreq

g<-ggplot(t,aes(x=trunclabel,y=popfreq))+geom_boxplot()+facet_grid(.~replicate)+scale_y_continuous(name="Population frequency")+xlab("")
postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/graphs/trunc-boxplots.ps",width=10,height=5)
plot(g)
dev.off()
