library(ggplot2)
library(gridExtra)
theme_set(theme_bw())

h<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/data/hot.txt")
c<-read.table("/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/data/cold40.txt")
names(h)<- c("replicate","generation","chromosome","position","popfreq")
names(c)<- c("replicate","generation","chromosome","position","popfreq")

# convert chromosome to ordered factor
h$chromosome <- factor(h$chromosome, levels=c("X", "2L", "2R", "3L", "3R", "4"))
c$chromosome <- factor(c$chromosome, levels=c("X", "2L", "2R", "3L", "3R", "4"))
lim<-c(0.0,0.51)
ybreaks<-c(0,0.1, 0.2,0.3, 0.4,0.5)


ph1<- ggplot(h[h$replicate==1,],aes(x=position,y=popfreq))+geom_point(size=0.5)+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)
ph3<- ggplot(h[h$replicate==3,],aes(x=position,y=popfreq))+geom_point(size=0.5)+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)
ph5<- ggplot(h[h$replicate==5,],aes(x=position,y=popfreq))+geom_point(size=0.5)+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)


pc1<- ggplot(c[c$replicate==1,],aes(x=position,y=popfreq))+geom_point(size=0.5)+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)
pc3<- ggplot(c[c$replicate==3,],aes(x=position,y=popfreq))+geom_point(size=0.5)+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)
pc5<- ggplot(c[c$replicate==5,],aes(x=position,y=popfreq))+geom_point(size=0.5)+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)

#pt1<- ggplot(t1,aes(x=position,y=popfreq))+geom_point(size=0.5)+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
#  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=c(0,0.3))








setEPS(horizontal = FALSE, onefile = FALSE, paper = "special")
postscript(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/graphs/hot-r1.ps",width=10,height=7)
plot(ph1)
dev.off()
postscript(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/graphs/hot-r3.ps",width=10,height=7)
plot(ph3)
dev.off()
postscript(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/graphs/hot-r5.ps",width=10,height=7)
plot(ph5)
dev.off()



postscript(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/graphs/cold-40-r1.ps",width=10,height=5)
plot(pc1)
dev.off()
postscript(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/graphs/cold-40-r3.ps",width=10,height=5)
plot(pc3)
dev.off()
postscript(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/graphs/cold-40-r5.ps",width=10,height=5)
plot(pc5)
dev.off()

#postscript(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/graphs/ts-r1.ps",width=10,height=9)
#plot(pt1)
#dev.off()



