library(ggplot2)
library(gridExtra)
theme_set(theme_bw())
palete <- c("darkgrey","red")
h<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/04-pirnacluster/visualize/teinsertions.hot.txt")
names(h)<- c("replicate","generation","chromosome","position","popfreq","cluster")

h<-subset(h,chromosome!="X" & chromosome!="2L" & chromosome!="2R" & chromosome!="3L"& chromosome!="3R" & chromosome!="4")

# convert chromosome to ordered factor
h$cluster<-as.factor(h$cluster)
h$size=2
#h[h$popfreq==-0.1,]$size=10
h[h$cluster==1,]$size=3

lim<-c(0.0,0.51)
ybreaks<-c(0,0.1, 0.2,0.3, 0.4,0.5)


ph1<- ggplot(h[h$replicate==1,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(replicate~chromosome, scales="free_x", space = "free_x")+
  scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")






setEPS(horizontal = FALSE, onefile = FALSE, paper = "special")
postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/04-pirnacluster/visualize/graph/hot-g20-unassembled.ps",width=10,height=7)
plot(ph1)
dev.off()






