library(ggplot2)
library(gridExtra)
theme_set(theme_bw())
palete <- c("darkgrey","red")

h<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/04-pirnacluster/visualize/teinsertions.hot.txt")
c<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/04-pirnacluster/visualize/teinsertions.cold.txt")
names(h)<- c("replicate","generation","chromosome","position","popfreq","cluster")
names(c)<- c("replicate","generation","chromosome","position","popfreq","cluster")
h<-subset(h,chromosome=="X" |chromosome=="2L"|chromosome=="2R"|chromosome=="3L"|chromosome=="3R"|chromosome=="4")
c<-subset(c,chromosome=="X" |chromosome=="2L"|chromosome=="2R"|chromosome=="3L"|chromosome=="3R"|chromosome=="4")

# convert chromosome to ordered factor
h$cluster<-as.factor(h$cluster)
h$size=2
h[h$popfreq==-0.1,]$size=10
h[h$cluster==1,]$size=3
c$size=2
c[c$popfreq==-0.1,]$size=10
c[c$cluster==1,]$size=3
c$cluster<-as.factor(c$cluster)
h$chromosome <- factor(h$chromosome, levels=c("X", "2L", "2R", "3L", "3R", "4"))
c$chromosome <- factor(c$chromosome, levels=c("X", "2L", "2R", "3L", "3R", "4"))
lim<-c(0.0,0.51)
ybreaks<-c(0,0.1, 0.2,0.3, 0.4,0.5)


ph1<- ggplot(h[h$replicate==1,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")
ph3<- ggplot(h[h$replicate==3,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")
ph5<- ggplot(h[h$replicate==5,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")


pc1<- ggplot(c[c$replicate==1,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")
pc3<- ggplot(c[c$replicate==3,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")
pc5<- ggplot(c[c$replicate==5,],aes(x=position,y=popfreq,col=cluster,size=size,stroke=0))+geom_point()+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=lim,breaks=ybreaks)+
  scale_colour_manual(values=palete)+theme(legend.position="none")

#pt1<- ggplot(t1,aes(x=position,y=popfreq))+geom_point(size=0.5)+facet_grid(generation~chromosome, scales="free_x", space = "free_x")+
#  scale_x_continuous(breaks=c(0,5000000,10000000,15000000,20000000,25000000),labels=c("0","5m","10m","15m","20m","25m"))+scale_y_continuous(name="Population frequency",limits=c(0,0.3))








setEPS(horizontal = FALSE, onefile = FALSE, paper = "special")
postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/04-pirnacluster/visualize/graph/hot-r1.ps",width=10,height=7)
plot(ph1)
dev.off()
postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/04-pirnacluster/visualize/graph/hot-r3.ps",width=10,height=7)
plot(ph3)
dev.off()
postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/04-pirnacluster/visualize/graph/hot-r5.ps",width=10,height=7)
plot(ph5)
dev.off()



postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/04-pirnacluster/visualize/graph/cold-r1.ps",width=10,height=5)
plot(pc1)
dev.off()
postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/04-pirnacluster/visualize/graph/cold-r3.ps",width=10,height=5)
plot(pc3)
dev.off()
postscript(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2018-01-review/04-pirnacluster/visualize/graph/cold-r5.ps",width=10,height=5)
plot(pc5)
dev.off()

#postscript(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-popfreq-mhp/graphs/ts-r1.ps",width=10,height=9)
#plot(pt1)
#dev.off()



